<?php
namespace Colorizer;

function asset_path($asset) {
    if (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG === true) {
        return plugins_url( 'assets/source/' . $asset . '.js', __FILE__ );
    }

    return plugins_url( 'assets/js/' . $asset . '.min.js', __FILE__ );
}

// Add scripts
add_action('wp_enqueue_scripts', function() {
    if( is_product() ) {
        $product = wc_get_product();
        $product_models = get_post_meta($product->get_id(), 'colorizer_data', true);
        if( $product->is_type('variable') && $product_models ) {
            wp_enqueue_script('babel-polyfill', plugins_url("assets/js/front/browser-polyfill.min.js", __FILE__ ));
            wp_enqueue_script('fabric', plugins_url("assets/js/editor/fabric.min.js", __FILE__ ));
            wp_enqueue_script('colorizer-product', asset_path('front/product'));
            wp_localize_script('colorizer-product', 'colorizer', [
                'attributes' => product_attributes($product),
                'models' => $product_models,
                'thumbnail_size' => get_option('shop_thumbnail_image_size'),
            ]);
        }
    }

    if( is_cart() ) {
        wp_enqueue_script('colorizer-cart', asset_path('front/cart'));
    }
});

// Save thumbnails
add_filter( 'woocommerce_add_cart_item_data', function($cart_item_data, $product_id ){
    //$beginning = 'data:image/jpeg;base64';
    if( !empty($_POST['colorizer_thumbnail']) && ( is_base64_jpeg($_POST['colorizer_thumbnail']) || is_base64_png($_POST['colorizer_thumbnail']) ) ) {
        $cart_item_data['colorizer_thumbnail'] = $_POST['colorizer_thumbnail'];
    }
    return $cart_item_data;
}, 100, 2);

// Show saved thumbnails in cart
add_filter( 'woocommerce_cart_item_thumbnail', function($html, $cart_item, $cart_item_key) {
    if( empty($cart_item['colorizer_thumbnail']) ) return $html;
    $html = preg_replace('/srcset=".*"/', '', $html);
    return preg_replace('/src="\S[^"\']*"/', 'src="'.$cart_item['colorizer_thumbnail'].'"', $html);
}, 100, 3);

// Save thumbnail
// add_action( 'woocommerce_new_order_item', function($item_id, $item) {
//     $beginning = 'data:image/jpeg;base64';
//     if( empty($item->legacy_values['colorizer_thumbnail']) || !is_base64_jpeg($item->legacy_values['colorizer_thumbnail']) ) return;
//     wc_add_order_item_meta($item_id, '_colorizer_thumbnail', $item->legacy_values['colorizer_thumbnail'], true);
// }, 100, 2 );
