<?php
/*
Plugin Name: Woocommerce Product Colorizer
Plugin URI: www.colorizer-demo.optart.pl
Description: Colorize your products! Plugin gives you a possibility of defining colors for your products. You don't need to upload images for each color.
Version: 4.2.1
Author: OptArt | Jakub Ptak
Author URI: http://www.optart.biz
WC requires at least: 3.3.0
WC tested up to: 4.0.1
*/

add_action( 'init', function() {
    if ( class_exists( 'woocommerce' ) ) {
        require_once('colorizer.php');
        Colorizer\init();
    }
} );

// Old colorizer import
register_activation_hook( __FILE__, function() {
    // Check if import has been done already before
    if( get_option('old_colorizer_import_done', false) ) return;

    // Update taxonomies - we have to map each term's color to new colorizer color
    import_old_taxonomies_to_new_colorizer();

    update_option('old_colorizer_import_done', true);
} );

function import_old_taxonomies_to_new_colorizer() {
    $old_taxonomies = ['colorizer-color', 'colorizer-logo-color'];
    foreach( $old_taxonomies as $taxonomy ) {
        if( !taxonomy_exists('pa_'.$taxonomy) ) return;
        $query = new WP_Term_Query([
            'taxonomy' => 'pa_'.$taxonomy,
            'hide_empty' => false,
        ]);

        foreach($query->get_terms() as $term) {
            $id = $term->term_id;
            $color = get_term_meta($id, $taxonomy, true);
            if( $color ) {
                add_term_meta($id, 'colorizer_color', $color, true);
            }
        }
    }
}

// Add demo functionality
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), function($links) {
    $url = get_admin_url() . '?colorizer_setup_demo=1';
    $link = "<a href=\"$url\">Create a demo product</a>";
    array_unshift($links, $link);

  	return $links;
}, 100);

require_once('demo-setup.php');

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}