<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Header settings.
 *
 * @return array
 */

$category = _x('Header', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'header';

return[
    self::add_toggle([
        'id' => 30,
        'index' => 'header',
        'name' => _x('Enable Header', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable / disable the header sitewide.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('enable header', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_visual_select([
        'id' => 31,
        'index' => 'header_layout',
        'adv' => true,
        'name' => _x('Header: Layout', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the base layout for header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('header layout', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'frontend',
        'default' => 'classic',
        'options' => [
            [
                'name' => _x('Classic', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'classic',
                'icon' => '/img/header_layout-classic.svg',
            ],
            [
                'name' => _x('Center Creative', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'center_creative',
                'icon' => '/img/header_layout-center_creative.svg',
            ],
            [
                'name' => _x('Classic Center', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'classic_center',
                'icon' => '/img/header_layout-classic_center.svg',
            ],
            [
                'name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'left',
                'icon' => '/img/header_layout-left.svg',
            ],
            [
                'name' => _x('Hamburger Classic', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'ham_classic',
                'icon' => '/img/header_layout-ham-classic.svg',
            ],
            [
                'name' => _x('Hamburger Center', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'ham_center',
                'icon' => '/img/header_layout-ham-center.svg',
            ],
            [
                'name' => _x('Hamburger Creative', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'ham_creative',
                'icon' => '/img/header_layout-ham-creative.svg',
            ],

        ],
    ]),
    self::add_color2([
        'id' => 240,
        'index' => 'header_ham_color',
        'adv' => true,
        'name' => _x('Hamburger Icon Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the normal and hover colors for menu hamburger icon.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('header hamburger icon color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'admin',
        'default' => [
            'm' => 'Body',
            'h' => 'Primary',
        ],
    ]),
    self::add_background([
        'id' => 32,
        'adv' => true,
        'index' => 'header_bg',
        'name' => _x('Header Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the header background.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('header background', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'blur' => true,
        'category_slug' => $category_slug,
        'module' => 'admin',
        'default' => [
            'blur' => 'false',
            'type' => 'solid',
            'solid' => '#ffffff',
            'gradient' => [
            'angle' => '90',
            'color1' => '#19187C',
            'color2' => '#532df5',
            ],
            'image' => [
            'url' => '',
            'attachment' => 'fixed',
            'position' => [
                'd' => 'center center',
                't' => 'center center',
                'm' => 'center center',
            ],
            'repeat' => 'no-repeat',
            'size' => [
                'd' => 'cover',
                't' => 'cover',
                'm' => 'contain',
            ],
            ],
        ],
    ]),
    self::add_input([
        'id' => 35,
        'adv' => true,
        'name' => _x('Header Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set top/bottom spacing for header bar.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('header padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 31,
        'visible' => array (
            'header_layout' => 'classic',
        ),
        'index' => 'header_padding',
        'category_slug' => $category_slug,
        'default' => '20',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 50,
        'suffix' => 'px',
    ]),
    self::add_input([
        'id' => 296,
        'adv' => true,
        'name' => _x('Header Bottom Area padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set top/bottom spacing for header bottom area bar.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('header bottom padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 31,
        'visible' => array (
            'header_layout' => 'center_creative',
        ),
        'index' => 'header_2_padding',
        'category_slug' => $category_slug,
        'default' => '20',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 50,
        'suffix' => 'px',
    ]),
    self::add_input([
        'id' => 36,
        'adv' => true,
        'name' => _x('Logo Height', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the header logo height.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('logo height', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'index' => 'header_logo_h',
        'category_slug' => $category_slug,
        'default' => '30',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 200,
        'suffix' => 'px',
    ]),
    self::add_toggle([
        'id' => 33,
        'adv' => true,
        'name' => _x('Header Border', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set a 1px border bottom to header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('header border', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'index' => 'header_border',
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_color([
        'id' => 34,
        'index' => 'header_borderc',
        'adv' => true,
        'name' => _x('Header Border Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the header border color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('header border color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 33,
        'visible' => array (
            'header_border' => 'true',
        ),
        'category_slug' => $category_slug,
        'default' => '#E6E9EC',
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 180,
        'adv' => true,
        'index' => 'header_shadow',
        'name' => _x('Header Shadow', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a box shadow on the header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('header shadow', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 31,
        'module' => 'frontend',
        'default' => 'true',
        'visible' => array (
            'header_layout' => 'classic',
        ),
    ]),
    self::add_select([
        'id' => 37,
        'index' => 'header_content_align',
        'adv' => true,
        'name' => _x('Content Alignment', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the inner content alignment for Left Header', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('header align', 'Admin - Theme Options Search', 'uicore-framework'),
        'category_slug' => $category_slug,
        'default' => 'left',
        'visible' => array (
            'header_layout' => 'left',
        ),
        'module' => 'admin',
        'options' => ['left', 'center'], // from Header.vue: contentalign
        'size' => 'm',
        'dependecies' => 31,
    ]),
    self::add_toggle([
        'id' => 50,
        'index' => 'header_transparent',
        'adv' => true,
        'name' => _x('Transparent Header', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set header to transparent background before scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('transparent header', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => [
            'm' => '#FFFFFF',
            'h' => 'Primary',
		],
        'module' => 'admin',
    ]),
    self::add_color2([
        'id' => 51,
        'index' => 'header_transparent_color',
        'adv' => true,
        'name' => _x('Transparent Header: Menu Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the menu color for transparent header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('transparent header menu color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 50,
        'default' => [
            'm' => '#FFFFFF',
            'h' => 'Primary',
        ],
        'visible' => array (
            'header_transparent' => 'true',
        ),
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 52,
        'index' => 'header_transparent_border',
        'adv' => true,
        'name' => _x('Transparent Header: Border', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a 1px border bottom to transparent header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('transparent header border', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 50,
        'visible' => array (
            'header_transparent' => 'true',
        ),
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'admin',
    ]),
    self::add_color([
        'id' => 53,
        'index' => 'header_transparent_borderc',
        'adv' => true,
        'name' => _x('Transparent Header: Border Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the border color for transparent header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('transparent header border color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 50,
        'visible' => array (
            'header_transparent' => 'true',
        ),
        'category_slug' => $category_slug,
        'default' => 'rgba(255, 255, 255, 0.2)',
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 54,
        'index' => 'header_wide',
        'adv' => true,
        'name' => _x('Wide Header', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Stretches the header container to full screen width.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('wide header', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 55,
        'index' => 'header_sticky',
        'adv' => true,
        'name' => _x('Sticky Header', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the header to fixed on top after scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('sticky header', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 56,
        'index' => 'header_shrink',
        'adv' => true,
        'name' => _x('Change Height On Scroll', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change header padding after scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('change height', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 55,
        'visible' => array (
            'header_sticky' => 'true',
        ),
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 57,
        'index' => 'header_padding_before_scroll',
        'adv' => true,
        'name' => _x('Padding Before Scroll', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the top/bottom padding of the header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('padding before scroll', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 56,
        'visible' => array (
            'header_shrink' => 'true',
        ),
        'category_slug' => $category_slug,
        'default' => '40',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 'm',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
    ]),
    self::add_toggle([
        'id' => 58,
        'index' => 'header_cta',
        'name' => _x('Call to Action Button', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a call to action button on the right side of the header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('call to action button', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 59,
        'index' => 'header_cta_inverted',
        'adv' => true,
        'name' => _x('Invert Colors on transparent header', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the call to action button style.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
        'tags' => _x('call to action button style', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 58,
        'visible' => array (
            'header_transparent' => 'true',
        ),
    ]),
    self::add_input([
        'id' => 61,
        'index' => 'header_ctatext',
        'name' => _x('Button Text', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the call to action button text.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('call to action button text', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 58,
        'visible' => array (
            'header_cta' => 'true',
        ),
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => 'Get a Quote',
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'text',
        'size' => 'm',
    ]),
    self::add_input([
        'id' => 62,
        'index' => 'header_ctalink',
        'name' => _x('Button Link', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the call to action button link.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('call to action button link', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 58,
        'visible' => array (
            'header_cta' => 'true',
        ),
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => '#',
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'text',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 63,
        'index' => 'header_cta_target',
        'adv' => true,
        'name' => _x('Link Target', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the call to action button link.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('call to action button link target', 'Admin - Theme Options Search', 'uicore-framework'),
        'category_slug' => $category_slug,
        'default' => '_self',
        'visible' => array (
            'header_cta' => 'true',
        ),
        'module' => 'admin',
        'options' => ['_self', '_blank', '_parent'], // from Header.vue: target
        'size' => 'm',
        'dependecies' => 58,
    ]),
    self::add_toggle([
        'id' => 64,
        'index' => 'header_search',
        'name' => _x('Search', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a search icon on the right side of the header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('search', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 31,
        'visible' => array (
            'header_layout' => 'classic',
        ),
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 65,
        'index' => 'header_icons',
        'name' => _x('Social Icons', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add social icons on the right side of the header (classic header) or bottom (left header).', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('social icons', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 66,
        'index' => 'header_custom_desktop',
        'name' => _x('Enable Widget Area (Desktop Screens Only)', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a custom widget area on the right side of the menu.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('widget area desktop', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 31,
        'visible' => true,
        'adv' => true,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_typography([
        'id' => 67,
        'index' => 'menu_typo',
        'adv' => true,
        'name' => _x('Menu Typography', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set menu text options.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('menu typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => [
            's' => '18',
            'h' => '1',
            'ls' => '0',
            't' => 'None',
            'st' => 'regular',
            'c' => 'Headline',
            'ch' => 'Primary',
            'f' => 'Primary',
        ],
        'module' => 'admin',
        'hover' => true,
        'color' => true,
        'line_height' => true,
        'family' => true,
        'responsive' => false,
        'full_responsive' => false,
    ]),
    self::add_input([
        'id' => 68,
        'index' => 'menu_spacing',
        'adv' => true,
        'name' => _x('Menu Item Spacing', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the left/right padding for menu items.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('menu item spacing', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => '50',
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
    ]),
    self::add_select([
        'id' => 69,
        'index' => 'menu_position',
        'adv' => true,
        'name' => _x('Menu Alignment', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the menu alignment on header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('menu alignment', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 31,
        'visible' => array (
            'header_layout' => 'classic',
        ),
        'default' => 'right',
        'module' => 'admin',
        'options' => ['left', 'center', 'right'], // likely from Header.vue position
        'size' => 'm',
    ]),
    self::add_color([
        'id' => 70,
        'adv' => true,
        'index' => 'submenu_bg',
        'name' => _x('Dropdown Background Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the dropdown menu background color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('dropdown background color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'Dark Neutral',
        'module' => 'admin',
    ]),
    self::add_typography([
        'id' => 71,
        'index' => 'submenu_color',
        'adv' => true,
        'name' => _x('Dropdown Menu Typography', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the dropdown menu text options.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('dropdown menu typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => [
            'f' => 'Primary',
            's' => '14',
            'h' => '1.1',
            'ls' => '0',
            't' => 'None',
            'st' => '500',
            'c' => 'Headline',
            'ch' => 'Primary',
        ],
        'module' => 'admin',
        'hover' => true,
        'color' => true,
        'line_height' => true,
        'family' => true,
        'responsive' => false,
        'full_responsive' => false,
    ]),
    self::add_input([
        'id' => 72,
        'index' => 'mobile_logo_h',
        'adv' => true,
        'name' => _x('Mobile Logo Height', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the logo height on mobile header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('mobile logo height', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => '24',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 200,
        'suffix' => 'px',
    ]),
    self::add_background([
        'id' => 73,
        'index' => 'mobile_menu_bg',
        'adv' => true,
        'name' => _x('Mobile Menu Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the mobile menu background.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('mobile menu background', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'admin',
        'blur' => true,
        'default' => [
            'blur' => 'false',
            'type' => 'solid',
            'solid' => '#ffffff',
            'gradient' => [
            'angle' => '90',
            'color1' => '#19187C',
            'color2' => '#532df5',
            ],
            'image' => [
                'url' => '',
                'attachment' => 'fixed',
                'position' => [
                    'd' => 'bottom center',
                    't' => 'center center',
                    'm' => 'center center',
                ],
                'repeat' => 'no-repeat',
                'size' => [
                    'd' => 'cover',
                    't' => 'cover',
                    'm' => 'contain',
                ],
            ],
        ],
    ]),
    self::add_toggle([
        'id' => 74,
        'index' => 'mmenu_logo',
        'adv' => true,
        'name' => _x('Use Secondary Logo', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Use secondary mobile logo on menu dropdown. If Secondary Mobile Logo is not set, Secondary Logo will be used instead.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('mobile secondary logo', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_typography([
        'id' => 76,
        'index' => 'mmenu_typo',
        'adv' => true,
        'name' => _x('Mobile Menu Typography', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set mobile menu text options.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('mobile menu typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => [
            's' => '18',
            'h' => '1',
            'ls' => '0',
            't' => 'None',
            'st' => 'regular',
            'c' => 'Headline',
            'ch' => 'Primary',
            'f' => 'Primary',
        ],
        'module' => 'admin',
        'hover' => true,
        'color' => true,
        'line_height' => false,
        'family' => true,
        'responsive' => false,
        'full_responsive' => false,
    ]),
    self::add_select([
        'id' => 77,
        'index' => 'mmenu_center',
        'adv' => true,
        'name' => _x('Mobile Menu Alignment', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set mobile menu text alignment.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('mobile menu alignment', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'left',
        'module' => 'admin',
        'options' => ['left', 'center', 'right'], // likely from Header.vue position
        'size' => 'm',
    ]),
    self::add_toggle([
        'id' => 78,
        'index' => 'header_custom_mobile',
        'name' => _x('Enable Widget Area (Mobile Screens Only)', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a custom widget area on the bottom on mobile menu popover.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('mobile widget area', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 209,
        'index' => 'animations_ham',
        'adv' => true,
        'name' => _x('Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the animation style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'fade in',
        'module' => 'frontend',
        'options' => ['none','fade','fade down','fade up'], // from Header.vue: menuAnimations
        'size' => 'm',
    ]),
    self::add_color([
        'id' => 211,
        'index' => 'animations_ham_color',
        'adv' => true,
        'name' => _x('Reveal Background Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'desc' => _x('Set the background color for reveal animation.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation reveal background color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'Primary',
        'module' => 'admin',
    ]),
    self::add_select([
        'id' => 216,
        'index' => 'animations_menu',
        'adv' => true,
        'name' => _x('Entrance Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the animation style for desktop menu.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('dektop menu animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'none',
        'module' => 'admin',
        'options' => ['none','fade','fade down','fade up'], // from Header.vue: menuAnimations
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 217,
        'index' => 'animations_menu_duration',
        'adv' => true,
        'name' => _x('Items Animation Duration', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the animation speed.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'normal',
        'module' => 'admin',
        'options' => ['slow','normal', 'fast'], // from Header.vue: duration
        'size' => 's',
    ]),
    self::add_input([
        'id' => 218,
        'index' => 'animations_menu_delay',
        'adv' => true,
        'name' => _x('Animation Delay', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'desc' => _x('Set the time before animation starts loading.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation delay', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => '500',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 5000,
        'suffix' => 'ms',
    ]),
    self::add_input([
        'id' => 219,
        'index' => 'animations_menu_delay_child',
        'adv' => true,
        'name' => _x('Delay Between Elements', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'desc' => _x('Set the animation delay between elements inside the header.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation delay elements', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => '200',
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'size' => 's',
        'min' => 0,
        'max' => 5000,
        'suffix' => 'ms',
    ]),
    self::add_select([
        'id' => 220,
        'index' => 'mmenu_animation',
        'adv' => true,
        'name' => _x('Mobile Menu Entrance Animation', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the animation style for mobile menu.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'fade',
        'module' => 'frontend',
        'options' => ['fade', 'slide along', 'slide on top', 'expand'], // from Header.vue: mmenu_animations
        'size' => 'm',
    ]),
    self::add_media([
        'id' => 241,
        'index' => 'menu_logo',
        'adv' => true,
        'name' => _x('Full Screen Menu Logo', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'desc' => _x('Select the logo you want to show inside the full screen menu (Hamburger Header).', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('header hamburger logo', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'none',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 242,
        'index' => 'menu_focus',
        'adv' => true,
        'name' => _x('Focus Hover Item', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'desc' => _x('Keeps the hover item in focus by decreasing opacity on the other items.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('header item focus', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_background([
        'id' => 243,
        'index' => 'menu_bg',
        'adv' => true,
        'name' => _x('Full Screen Menu Background', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the background for full screen menu (Hamburger Header).', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('header menu background', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'admin',
        'blur' => true,
        'default' => [
            'type' => 'solid',
            'solid' => 'rgba(0, 0, 0, 0.8)',
            'gradient' => [
            'angle' => '180',
            'color1' => '#070707',
            'color2' => '#202020',
            ],
            'image' => [
                'url' => '',
                'attachment' => 'scroll',
                'position' => [
                    'd' => 'center center',
                    't' => 'center center',
                    'm' => 'center center',
                ],
                'repeat' => 'repeat',
                'size' => [
                    'd' => 'cover',
                    't' => 'cover',
                    'm' => 'contain',
                ],
            ],
        ],
    ]),
    self::add_toggle([
        'id' => 244,
        'index' => 'menu_active',
        'adv' => true,
        'name' => _x('Highlight Current Page', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'desc' => _x('Uses menu hover color to highlight current page menu item.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('header current page highlight', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 295,
        'index' => 'header_sticky_smart',
        'name' => _x('Smart Sticky', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Sticky header appears when scrolling up.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('smart sticky', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 55,
        'visible' => array(
            'header_sticky' => 'true',
        ),
        'adv' => true,
        'category_slug' => $category_slug,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 297,
        'index' => 'header_side_drawer',
        'name' => _x('Side Drawer', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a side drawer toggle in the header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('side drawer', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'category_slug' => $category_slug,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 298,
        'adv' => false,
        'index' => 'header_sd_text',
        'name' => _x('Side Drawer Text', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the side drawer toggle text.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('side drawer text', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 297,
        'visible' => array(
            'header_side_drawer' => 'true',
        ),
        'category_slug' => $category_slug,
        'default' => '',
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'text',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 299,
        'index' => 'header_sd_toggle',
        'adv' => true,
        'name' => _x('Side Drawer Toggle', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the side drawer open action.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('side drawer toggle', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 297,
        'visible' => array(
            'header_side_drawer' => 'true',
        ),
        'default' => 'hover',
        'module' => 'admin',
        'options' => ['click', 'hover'], // from Header.vue: toggle_mode
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 300,
        'index' => 'header_sd_position',
        'adv' => true,
        'name' => _x('Side Drawer Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the side drawer position.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('side drawer position', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 297,
        'visible' => array(
            'header_side_drawer' => 'true',
        ),
        'default' => 'right',
        'module' => 'admin',
        'options' => ['left', 'right'], // from Header.vue: position_sd
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 319,
        'index' => 'menu_interaction',
        'adv' => true,
        'name' => _x('Menu Hover Interaction', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the hover effect for menu items.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('menu hover interaction', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'none',
        'module' => 'frontend',
        'options' => ['none', 'button', 'underline', 'text flip', 'focus', 'magnet button','website'], // from Header.vue: interactions
        'size' => 'm',
    ]),
    self::add_input([
        'id' => 328,
        'adv' => true,
        'index' => 'mobile_breakpoint',
        'name' => _x('Mobile Navigation Breakpoint', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the screen resolution where the mobile menu replaces the desktop menu.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('header mobile breakpoint', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'responsive' => false,
        'module' => 'frontend',
        'default' => '1025',
        'accept' => 'number',
        'size' => 's',
        'min' => 500,
        'max' => 2450,
        'suffix' => 'px',
    ]),
    self::add_select([
        'id' => 339,
        'index' => 'submenu_trigger',
        'adv' => false,
        'name' => _x('Dropdown Menu Trigger', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the action that triggers the submenu.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('submenu dropdown trigger', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => null,
        'visible' => true,
        'default' => 'hover',
        'module' => 'admin',
        'options' => ['hover', 'click'], // from Header.vue: toggle_mode
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 341,
        'adv' => true,
        'size' => 'm',
        'index' => 'header_pill',
        'module' => 'frontend',
        'default' => 'false',
        'name' => _x('Pill Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable Header pill style', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('header pill style', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => array(
            '!header_layout' => 'left',
        ),
        'options'=> array(
            [
                'name' =>_x('Disabled', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'false',
            ],
            [
                'name' =>_x('Simple', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'true',
            ],
            [
                'name' =>_x('Compact', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'compact',
            ],
            [
                'name' =>_x('Menu', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'menu',
            ],
            [
                'name' =>_x('Logo and Menu', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'logo-menu',
            ]
        ),
    ]),
    self::add_input([
        'id' => 342,
        'adv' => true,
        'child' => true,
        'type' => 'input',
        'default' => '18',
        'index' => 'header_pill_radius',
        'module' => 'admin',
        'accept' => 'number',
        'suffix' => 'px',
        'size' => 's',
        'min' => 0,
        'max' => 100,
        'name' => _x('Pill Border Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the pill border radius', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'responsive' => false,
        'tags' => _x('header pill style boder radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 341,
        'visible' => array (
            '!header_pill' => 'false',
        ),
    ]),
    self::add_input([
        'id' => 346,
        'index' => 'mobile_back',
        'adv' => true,
        'name' => _x('“Back” Button Text', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Change the text for the “Back” button in the mobile submenu. If  is left empty "back" will be replaced by the submenu title', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => __('Back', 'uicore-framework'),
        'tags' => _x('mobile menu header translate back', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'frontend',
        'accept' => 'text',
        'size' => 'm',
        'responsive' => false,
    ]),
    self::add_visual_select([
        'id' => 351,
        'type' => 'layout',
        'index' => 'mobile_layout',
        'module' => 'frontend',
        'default' => 'default',
        'adv' => true,
        'name' => _x('Mobile Header: Layout', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the base layout for mobile header.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('mobile header layout', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'options'=> [
            [
                'name' => _x('Default', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'default',
                'icon' => '/img/mobile_header_layout-default.svg',
            ],
            [
                'name' => _x('Center', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'center',
                'icon' => '/img/mobile_header_layout-center.svg',
            ]
        ],
        // 'prefix' => 'mobile_header_layout', TODO: whats prefix for?
    ]),
    self::add_select([
        'id' => 353,
        'adv' => true,
        'size' => 'm',
        'index' => 'mobile_pill',
        'module' => 'admin',
        'default' => 'false',
        'name' => _x('Mobile Pill Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable Mobile Header pill style', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('mobile header pill style', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => array(
            '!header_layout' => 'left',
        ),
        'options'=> array(
            [
                'name' =>_x('Disabled', 'Admin - Theme Options - Mobile Pill Style', 'uicore-framework'),
                'value' => 'false',
            ],
            [
                'name' =>_x('Simple', 'Admin - Theme Options - Mobile Pill Style', 'uicore-framework'),
                'value' => 'true',
            ],
        ),
    ]),
    self::add_input([
        'id' => 354,
        'adv' => true,
        'type' => 'input',
        'index' => 'mobile_pill_radius',
        'module' => 'admin',
        'default' => '12',
        'suffix' => 'px',
        'size' => 's',
        'min' => 0,
        'max' => 200,
        'accept' => 'number',
        'name' => _x('Mobile Pill Border Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the mobile pill border radius', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'responsive' => false,
        'tags' => _x('mobile header pill style boder radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 353,
        'visible' => array (
            'mobile_pill' => 'true',
        ),
    ]),
    self::add_select([
        'id' => 355,
        'index' => 'animations_submenu',
        'adv' => true,
        'name' => _x('Dropdown  Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the submenu animation style.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'fade up',
        'module' => 'admin',
        'options' => ['none','fade','fade down','fade up', 'fade left', 'scale down', 'rotate','scale bg' ,'website blur'], // from Header.vue: submenuAnimations
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 356,
        'index' => 'animations_submenu_duration',
        'adv' => true,
        'name' => _x('Dropdown Animation Duration', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation speed.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'normal',
        'module' => 'admin',
        'options' => ['slow','normal', 'fast'], // from Header.vue: duration
        'size' => 's',
    ]),
    self::add_select([
        'id' => 357,
        'index' => 'animations_submmenu',
        'module' => 'frontend',
        'adv' => true,
        'name' => _x('Dropdown Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation type.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'size' => 'm',
        'default' => 'slide',
        'options' => ['slide', 'expand'],
    ]),
    self::add_color([
        'id' => 362,
        'adv' => true,
        'index' => 'animations_preloader_color',
        'module' => 'frontend',
        'default' => 'White',
        'name' => _x('Preloader Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Choose the preloader color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('page transition prelaod animation preloader text', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => null,
        'visible' => [
            '!animations_preloader' => 'none',
        ],
        'category_slug' => $category_slug,
    ]),
    self::add_color([
        'id' => 376,
        'adv' => true,
        'index' => 'menu_interaction_color',
        'module' => 'admin',
        'default' => 'Primary',
        'name' => _x('Menu Interaction Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the menu interaction color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('menu interaction color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => [
            '!menu_interaction' => 'none',
        ],
    ]),
    self::add_input([
        'id' => 380,
        'adv' => true,
        'default' => '0',
        'index' => 'header_pill_top_spacing',
        'module' => 'admin',
        'accept' => 'number',
        'suffix' => 'px',
        'size' => 's',
        'min' => 0,
        'max' => 200,
        'name' => _x('Pill Top Spacing', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the header top spacing', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'responsive' => false,
        'tags' => _x('header pill top spacing', 'Admin - Theme Options Search', 'uicore-framework'),
        'visible' => [
            '!header_pill' => 'false',
        ]
    ]),
    self::add_input([
        'id' => 418,
        'adv' => true,
        'type' => 'input',
        'index' => 'mobile_menu_padding',
        'module' => 'admin',
        'default' => '',
        'suffix' => 'px',
        'size' => 's',
        'min' => '0',
        'max' => '100',
        'accept' => 'number',
        'name' => _x('Mobile Menu Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the mobile menu padding.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'tags' => _x('mobile menu padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'category_slug' => $category_slug,
        'responsive' => false,
    ]),
];