<?php
namespace UiCore\Settings;

defined('ABSPATH') || exit();

/**
 * Woocommerce settings.
 *
 * @return array
 */

$category = _x('Woocommerce', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'woocommerce';

$sidebar_options = [
    ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'none'],
    ['name' => _x('Blog Post', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Blog Post'],
    ['name' => _x('Blog Archive', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Blog Archive'],
    ['name' => _x('Portfolio Post', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Portfolio Post'],
    ['name' => _x('Portfolio Archive', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Portfolio Archive'],
    ['name' => _x('WooCommerce Shop', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'WooCommerce Shop'],
    ['name' => _x('WooCommerce Product', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'WooCommerce Product'],
];

return [
    self::add_toggle([
        'id' => 161,
        'index' => 'woo',
        'adv' => false,
        'name' => _x('Header Cart Icon', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / hide a shopping cart icon on the right side of the header.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('shop page', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 162,
        'index' => 'woocommerce_col',
        'adv' => true,
        'name' => _x('Grid Columns', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the number of columns for shop page grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid columns', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '3',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('2 Columns', 'Admin - Theme Options', 'uicore-framework'), 'value' => '2'],
            ['name' => _x('3 Columns', 'Admin - Theme Options', 'uicore-framework'), 'value' => '3'],
            ['name' => _x('4 Columns', 'Admin - Theme Options', 'uicore-framework'), 'value' => '4'],
            ['name' => _x('5 Columns', 'Admin - Theme Options', 'uicore-framework'), 'value' => '5'],
        ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 413,
        'index' => 'woo_grid_gap',
        'adv' => true,
        'name' => _x('Product Grid Gap', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product grid gap.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product grid gap', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '30',
        'visible' => true,
        'responsive' => false,
        'module' => 'admin',
        'accept' => 'number',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_select([
        'id' => 402,
        'index' => 'woo_item_style',
        'adv' => true,
        'name' => _x('Item Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Choose a style for product items in the shop.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('item style woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'default',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
            'name' => _x('Default', 'Admin - Theme Options', 'uicore-framework'),
            'value' => 'default',
            ],
            [
            'name' => _x('Boxed', 'Admin - Theme Options', 'uicore-framework'),
            'value' => 'boxed',
            ],
            [
            'name' => _x('Shadow', 'Admin - Theme Options', 'uicore-framework'),
            'value' => 'shadow',
            ]
        ],
        'size' => 's',
    ]),
    self::add_select([
        'id' => 403,
        'index' => 'woo_hover_effect',
        'adv' => true,
        'name' => _x('Hover Effect', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Choose a hover effect for product items.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('hover effect woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'zoom',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
                [
                    'name' => _x('Zoom', 'Admin - Theme Options', 'uicore-framework'),
                    'value' => 'zoom',
                ],
                [
                    'name' => _x('Transform', 'Admin - Theme Options', 'uicore-framework'),
                    'value' => 'transform',
                ],
                [
                    'name' => _x('Change Image', 'Admin - Theme Options', 'uicore-framework'),
                    'value' => 'change_image',
                ],
            ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 404,
        'index' => 'woo_img_radius',
        'adv' => true,
        'name' => _x('Product Image Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product image radius.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product image radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '0',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 411,
        'index' => 'woo_align_center',
        'adv' => true,
        'name' => _x('Center Product Grid info', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Center the product grid information.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product grid center', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_select([
        'id' => 412,
        'index' => 'woo_add_to_cart_style',
        'adv' => true,
        'name' => _x('Add to Cart Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the add to cart style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product add to cart style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'reveal',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Default', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'btn',
            ],
            [
                'name' => _x('Show on Hover', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'btn_hover',
            ],
            [
                'name' => _x('Link', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'link',
            ],
            [
                'name' => _x('Link Reveal', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'reveal',
            ],
        ],
        'size' => 's',
    ]),
    self::add_typography([
        'id' => 405,
        'adv' => true,
        'type' => 'typography',
        'index' => 'woo_title',
        'module' => 'admin',
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => '22',
                't' => '20',
                'm' => '18',
            ],
            'h' => '1.2',
            'ls' => '0',
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'hover' => false,
        'family'   => true,
        'responsive'  => true,
        'full_responsive' => false,
        'line_height' => true,
        'color'   => true,
        'name' => _x('Product Title', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product title typography.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('product title typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_typography([
        'id' => 406,
        'adv' => true,
        'type' => 'typography',
        'index' => 'woo_price',
        'module' => 'admin',
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => '14',
                't' => '14',
                'm' => '14',
            ],
            'h' => '1.2',
            'ls' => '0',
            't' => 'None',
            'st' => '500',
            'c' => 'Body',
        ],
        'hover' => false,
        'family'   => true,
        'responsive'  => true,
        'full_responsive' => false,
        'line_height' => true,
        'color'   => true,
        'name' => _x('Product Price', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product price typography.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('product price typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_toggle([
        'id' => 408,
        'index' => 'woo_rating',
        'adv' => true,
        'name' => _x('Show Rating', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the rating in the product grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product rating', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 409,
        'index' => 'woo_swatches',
        'adv' => true,
        'name' => _x('Show Swatches', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the swatches in the product grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product swatches', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 410,
        'index' => 'woo_quick_desc',
        'adv' => true,
        'name' => _x('Show Quick Description', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the quick description in the product grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product quick description', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_typography([
        'id' => 407,
        'adv' => true,
        'type' => 'typography',
        'index' => 'woo_description',
        'module' => 'admin',
        'default' =>[
            'f' => 'Text',
            's' => [
            'd' => '14',
            't' => '14',
            'm' => '14',
            ],
            'h' => '1.5',
            'ls' => '0',
            't' => 'None',
            'st' => 'regular',
            'c' => 'Body',
        ],
        'category' => $category,
        'category_slug' => $category_slug,
        'hover' => false,
        'family'   => true,
        'responsive'  => true,
        'full_responsive' => false,
        'color'   => true,
        'line_height' => true,
        'name' => _x('Product Description', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product description typography.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('WooCommerce', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product description typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'visible' => 410,
    ]),
    self::add_input([
        'id' => 163,
        'index' => 'woocommerce_padding',
        'adv' => true,
        'name' => _x('Shop Page Vertical Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the top/bottom spacing for shop page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('vertical padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'd' => '100',
            't' => '75',
            'm' => '45',
        ],
        'visible' => true,
        'module' => 'admin',
        'responsive' => true,
        'accept' => 'number',
        'min' => 0,
        'max' => 1000,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_input([
        'id' => 164,
        'index' => 'woocommerce_posts_number',
        'adv' => true,
        'name' => _x('Products on Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set number of products displayed on a page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('products number', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '12',
        'visible' => true,
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'number',
        'min' => 2,
        'max' => 100,
        'suffix' => '',
        'size' => 's',
    ]),
    self::add_select([
        'id' => 235,
        'index' => 'animations_shop',
        'adv' => false,
        'name' => _x('Entrance Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'none',
        'visible' => true,
        'module' => 'admin',
        'options' => [
            ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'none'],
            ['name' => _x('Fade', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade'],
            ['name' => _x('Fade Down', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade down'],
            ['name' => _x('Fade Up', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade up'],
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 236,
        'index' => 'animations_shop_duration',
        'adv' => false,
        'name' => _x('Animation Duration', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation speed.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'normal',
        'visible' => true,
        'module' => 'admin',
        'options' => [
            ['name' => _x('Slow', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'slow'],
            ['name' => _x('Normal', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'normal'],
            ['name' => _x('Fast', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fast'],
        ],
        'size' => 's',
    ]),

    // ID: 237 - Animation Delay
    self::add_input([
        'id' => 237,
        'index' => 'animations_shop_delay_child',
        'adv' => false,
        'name' => _x('Delay Between Elements', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('Animations', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation delay between elements inside the shop grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('animation delay elements', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '200',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 5000,
        'suffix' => 'ms',
        'size' => 's',
    ]),
    self::add_select([
        'id' => 165,
        'index' => 'woocommerce_sidebar_id',
        'adv' => false,
        'name' => _x('Shop Page Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar for shop page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('shop page sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'none',
        'visible' => true,
        'module' => 'frontend',
        'options' => $sidebar_options,
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 166,
        'index' => 'woocommerce_sidebar',
        'adv' => false,
        'name' => _x('Shop Page Sidebar Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar position for shop page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('shop sidebar position', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'left',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Right', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'right'],
            ['name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'left'],
            ['name' => _x('Top', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'top'],
            ['name' => _x('Side Drawer', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'side drawer'],
        ],
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 167,
        'index' => 'woocommerce_sidebars',
        'adv' => false,
        'name' => _x('Shop Page Sticky Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar to sticky on page scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('shop sidebar sticky', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 401,
        'index' => 'woo_filters_toggle',
        'adv' => true,
        'name' => _x("Shop Page Filters Toggle", 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Adds a toggle button for the shop page sidebar.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('shop filters toggle', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 340,
        'index' => 'woocommerces_title',
        'adv' => true,
        'name' => _x('Product Page Title Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the page title style for product pages.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product page title woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'default page title',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Default Page Title', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'default page title'
            ],
            [
                'name' => _x('Simple Page Title', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'simple page title'
            ],
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 168,
        'index' => 'woocommerces_sidebar_id',
        'adv' => false,
        'name' => _x('Product Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Select a sidebar for product pages.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product sidebar woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'none',
        'visible' => true,
        'module' => 'frontend',
        'options' => $sidebar_options,
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 169,
        'index' => 'woocommerces_sidebar',
        'adv' => false,
        'name' => _x('Product Page Sidebar Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar position for product page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product sidebar position', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'left',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Right', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'right'],
            ['name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'left'],
        ],
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 170,
        'index' => 'woocommerces_sidebars',
        'adv' => false,
        'name' => _x('Product Page Sticky Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar to sticky on page scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product sidebar sticky', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 394,
        'index' => 'woos_product_gallery',
        'adv' => true,
        'name' => _x('Gallery Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the gallery style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product gallery style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Default', 'Admin - Theme Options', 'uicore-framework'),
                'value' => '',
            ],
            [
                'name' => _x('Left Thumbnails', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'left_thumbs',
            ],
            [
                'name' => _x('One Column', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'grid_column',
            ],
            [
                'name' => _x('Two Columns', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'grid_column_2',
            ],
        ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 396,
        'index' => 'woos_gallery_gap',
        'adv' => true,
        'name' => _x('Gallery Gap', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the gallery gap.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product gallery gap', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '20',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_input([
        'id' => 397,
        'index' => 'woos_gallery_radius',
        'adv' => true,
        'name' => _x('Gallery Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the gallery radius.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => _x('WooCommerce', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product gallery radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '0',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_input([
        'id' => 398,
        'index' => 'woos_summary_width',
        'adv' => true,
        'name' => _x('Summary Width', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the summary width.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product summary width', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '37',
        'visible' => true,
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'number',
        'min' => 20,
        'max' => 80,
        'suffix' => '%',
        'size' => 's',
    ]),
    self::add_typography([
        'id' => 389,
        'index' => 'woos_title',
        'adv' => true,
        'name' => _x('Product Title Typography', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set product page title typography.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product title typography woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => '32',
                't' => '28',
                'm' => '24',
            ],
            'h' => '1.44',
            'ls' => '0',
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'module' => 'frontend',
        'hover' => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => true,
        'color' => true,
    ]),
    self::add_typography([
        'id' => 390,
        'index' => 'woos_price',
        'adv' => true,
        'name' => _x('Product Price', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product price typography.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product price typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'f' => 'Primary',
            's' => [
                'd' => '24',
                't' => '22',
                'm' => '20',
            ],
            'h' => '1.44',
            'ls' => '0',
            't' => 'None',
            'st' => '600',
            'c' => 'Headline',
        ],
        'visible' => true,
        'module' => 'admin',
        'hover' => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => false,
        'color' => true,
    ]),
    self::add_typography([
        'id' => 391,
        'index' => 'woos_excerpt',
        'adv' => true,
        'name' => _x('Product Excerpt', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the product excerpt typography.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product excerpt typography', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => [
            'f' => 'Text',
            's' => [
                'd' => '16',
                't' => '15',
                'm' => '14',
            ],
            'h' => '1.875',
            'ls' => '0',
            't' => 'None',
            'st' => 'regular',
            'c' => 'Body',
        ],
        'visible' => true,
        'module' => 'admin',
        'hover' => false,
        'family' => true,
        'line_height' => true,
        'responsive' => true,
        'full_responsive' => false,
        'color' => true,
    ]),
    self::add_select([
        'id' => 388,
        'index' => 'woos_rating_style',
        'adv' => true,
        'name' => _x('Rating Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the rating style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product rating style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'stars',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Stars', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'stars'],
            ['name' => _x('Bar', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'bar'],
        ],
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 415,
        'index' => 'woos_sku',
        'adv' => true,
        'name' => _x('Show SKU', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show/hide product SKU.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('sku woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 386,
        'index' => 'woos_category',
        'adv' => true,
        'name' => _x('Show Category', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the category in the product grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product category', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 387,
        'index' => 'woos_tags',
        'adv' => true,
        'name' => _x('Show Tags', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the tags in the product grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product tags', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 400,
        'index' => 'woos_share',
        'adv' => true,
        'name' => _x('Show Share Links', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the share product in the product grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product share links', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 399,
        'index' => 'woos_add_to_cart_height',
        'adv' => true,
        'name' => _x('Add to Cart Button Height', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set add to cart button height.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('add to cart height woocommerce', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '44',
        'visible' => true,
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'number',
        'min' => 30,
        'max' => 100,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 416,
        'index' => 'woos_ajax_add_to_cart',
        'adv' => true,
        'name' => _x('Ajax Add to Cart', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable / Disable the ajax add to cart functionality.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product ajax add to cart', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 381,
        'index' => 'woos_swatch_size',
        'adv' => true,
        'name' => _x('Swatch Size', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the swatch size.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('swatch size', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '30',
        'visible' => true,
        'module' => 'admin',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 200,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_select([
        'id' => 382,
        'index' => 'woos_swatch_radius',
        'adv' => true,
        'name' => _x('Swatch Border Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the swatch border radius.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('swatch border radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '0',
        'visible' => true,
        'module' => 'frontend',
        'responsive' => false,
        'options' => [
            ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => ''],
            ['name' => _x('Small', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'small'],
            ['name' => _x('Medium', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'medium'],
            ['name' => _x('Large', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'large'],
        ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 383,
        'index' => 'woos_swatch_border',
        'adv' => true,
        'name' => _x('Swatch Border Size', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the swatch border size.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('swatch border size', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '1',
        'visible' => true,
        'module' => 'frontend',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 100,
        'suffix' => 'px',
        'size' => 's',
    ]),
    self::add_color([
        'id' => 384,
        'index' => 'woos_swatch_border_color',
        'adv' => true,
        'name' => _x('Swatch Border Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the swatch border color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('swatch border color', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '#222222',
        'visible' => true,
        'module' => 'admin',
    ]),
    self::add_toggle([
        'id' => 395,
        'index' => 'woo_swatch_inherit_image',
        'adv' => true,
        'name' => _x('Inherit product variation images', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('If enabled, Image type Swatches will try to pull custom images set on each product attribute terms, showing fixed term images only as fallback.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product swatch image inherit', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 392,
        'index' => 'woos_tabs_position',
        'adv' => true,
        'name' => _x('Tabs Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the tabs position.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product tabs position', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'false',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 393,
        'index' => 'woos_tabs_style',
        'adv' => true,
        'name' => _x('Tabs Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the tabs style.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product tabs style', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => '',
        'visible' => true,
        'module' => 'frontend',
        'options' => [
            [
              'name' => _x('Horizontal Tabs', 'Admin - Theme Options', 'uicore-framework'),
              'value' => '',
            ],
            [
              'name' => _x('Vertical Tabs', 'Admin - Theme Options', 'uicore-framework'),
              'value' => 'vertical',
            ],
            [
              'name' => _x('Accordion', 'Admin - Theme Options', 'uicore-framework'),
              'value' => 'accordion',
            ],
            [
              'name' => _x('Sections', 'Admin - Theme Options', 'uicore-framework'),
              'value' => 'sections',
            ],
        ],
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 414,
        'index' => 'woos_related',
        'adv' => true,
        'name' => _x('Show Related Products', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the related products in the product page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product related products', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 385,
        'index' => 'woos_sticky_add_to_cart',
        'adv' => true,
        'name' => _x('Sticky Add to Cart Bar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the sticky add to cart bar.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('product sticky add to cart', 'Admin - Theme Options Search', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'default' => 'true',
        'visible' => true,
        'module' => 'frontend',
    ]),
];