<?php

namespace Merkulove\Readabler\Tabs;

use Merkulove\Readabler\Config;
use Merkulove\Readabler\Unity\Plugin;
use Merkulove\Readabler\Unity\Settings;
use Merkulove\Readabler\Unity\Tab;

class TabInitialSettings extends Tab {

	/**
	 * @var string
	 */
	public static string $key = 'initial_settings';

	/**
	 * Controls for General tab.
	 * @return array
	 */
	public static function controls(): array {

		$options = Settings::get_instance()->options;
		$fields = [];

		$fields['start_config_settings_header'] = [
			'type'        => 'header',
			'description' => esc_html__( 'These settings determine which modes will be automatically applied to the page after it is loaded.', 'readabler' ),
			'default'     => ''
		];

		$fields['start_config'] = [
			'type'        => 'chosen',
			'label'       => esc_html__( 'Start Configuration', 'readabler' ) . ':',
			'description' => esc_html__( 'Select the modes that will be applied after the page is loaded.', 'readabler' ),
			'options'     => self::get_start_config_options( $options ),
			'default'     => '',
			'attr'        => [
				'multiple' => 'multiple',
			],
		];

		$key                                        = 'start_content_scaling';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Content Scaling', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Initial content scaling', 'readabler' ) . ':',
				'unit' => '%',
				'default_fallback' => esc_html__( 'Default', 'readabler' )
			],
			'min'         => -100,
			'max'         => 100,
			'step'        => 5,
			'default'     => 0,
			'discrete'    => true,
		];

		$key                                        = 'start_font_sizing';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Font Sizing', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Initial font sizing', 'readabler' ) . ':',
				'unit' => '%',
				'default_fallback' => esc_html__( 'Default', 'readabler' )
			],
			'min'         => -100,
			'max'         => 100,
			'step'        => 5,
			'default'     => 0,
			'discrete'    => true,
		];

		$key                                        = 'start_line_height';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Line Height', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Initial line height', 'readabler' ) . ':',
				'unit' => '%',
				'default_fallback' => esc_html__( 'Default', 'readabler' )
			],
			'min'         => -100,
			'max'         => 100,
			'step'        => 5,
			'default'     => 0,
			'discrete'    => true,
		];

		$key                                        = 'start_letter_spacing';
		$fields[ $key ] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Letter Spacing', 'readabler' ) . ':',
			'description' => [
				'prefix' => esc_html__( 'Initial letter spacing', 'readabler' ) . ':',
				'unit' => '%',
				'default_fallback' => esc_html__( 'Default', 'readabler' )
			],
			'min'         => -100,
			'max'         => 100,
			'step'        => 5,
			'default'     => 0,
			'discrete'    => true,
		];

		$fields['save_config'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Save config', 'readabler' ),
			'description' => esc_html__( 'Save the configuration and apply it after page reload.', 'readabler' ),
			'default'     => 'on',
		];

		$fields['ignore_saved_config'] = [
			'type'        => 'switcher',
			'label'       => esc_html__( 'Ignore user config', 'readabler' ),
			'description' => esc_html__( 'Ignore the user configuration that was saved after previous visit.', 'readabler' ),
			'default'     => 'off',
		];

		return $fields;

	}

	/**
	 * Add Initial Settings tab to the settings page.
	 * @return void
	 */
	public static function add_tab() {
		self::add_settings_tab(
			self::$key,
			7,
			'tune',
			esc_html__( 'Initial settings', 'readabler' ),
			esc_html__( 'Initial accessibility settings', 'readabler' ),
			esc_html__( 'Configure initial accessibility settings for your website visitors. These settings will be applied when a user first interacts with the Readabler accessibility interface.', 'readabler')
		);
	}

	/**
	 * Add fields to the tab.
	 * @return void
	 */
	public static function add_controls() {
		$tabs                         = Plugin::get_tabs();
		$tabs[ self::$key ]['fields'] = self::controls();
		Plugin::set_tabs( $tabs );
	}

	/**
	 * Get an initial config options list
	 *
	 * @param $settings
	 *
	 * @return array
	 */
	private static function get_start_config_options( $settings ): array {
		// Add only ON options
		return array_filter( Config::all_accessibility_modes(), function ( $option_name ) use ( $settings ) {
			return ( $settings[ $option_name ] ?? 'off' ) === 'on';
		}, ARRAY_FILTER_USE_KEY );
	}

}
