<?php
/**
 *
 * @link              https://1.envato.market/mgXE4y
 * @since             1.0.0
 * @package           WP_User_Channel
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

$settings = WP_User_Channel_Admin::get_settings();
?>
<div class="wrap">
	<h1><?php esc_html_e( 'WP User Channel', 'wp-user-channel' )?></h1>

	<form method="post">
		
		<table class="form-table">

			<tbody>
				
				<tr>
					<th scope="row">
						<label for="max_channels"><?php esc_html_e( 'Maximum Channels', 'wp-user-channel' );?></label>
					</th>
					<td>
						<?php printf(
							'<input name="wp_user_channel[max_channels]" type="number" id="max_channels" value="%s" class="regular-text">',
							absint( $settings['max_channels'] )
						);?>

						<p class="description">
							<?php esc_html_e( 'Maximum number of channels that members can create. This limit does not apply to administrators. Set to 0 for unlimited.', 'wp-user-channel' );?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label><?php esc_html_e( 'Default Channel Roles', 'wp-user-channel' );?></label>
					</th>
					<td>
						<ul class="wpuc-list-role">

							<?php foreach ( get_editable_roles() as $role => $data  ): ?>
								<?php if( array_key_exists( 'edit_posts', $data['capabilities'] ) && wp_validate_boolean( $data['capabilities']['edit_posts'] ) && ! array_key_exists( 'delete_others_posts', $data['capabilities'] ) ): ?>
									<li><label>
									<?php printf(
										'<input name="wp_user_channel[default_roles][]" type="checkbox" id="max_channels" value="%s" %s/>',
										esc_attr( $role ),
										in_array( $role , $settings['default_roles'] ) ? 'checked' : ''
									);?>
									<?php printf(
										'%s (%s)',
										$data['name'],
										$role
									); ?>
									</label></li>
								<?php endif;?>
							<?php endforeach; ?>
						</ul>

						<p class="description">
							<?php esc_html_e( 'If no roles are assigned, new channels will be granted all available roles from the primary account.', 'wp-user-channel' );?>
						</p>

						<p class="description" style="font-weight: bold;color: red">
							<?php esc_html_e( '!!! Do not select roles with high capabilities, as this may lead to potential security risks, leave blank if you are unsure.', 'wp-user-channel' );?>					
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label><?php esc_html_e( 'Who is permitted to create channels?', 'wp-user-channel' );?></label>
					</th>
					<td>
						<ul class="wpuc-list-role">
							<?php foreach ( get_editable_roles() as $role => $data  ): ?>
								<?php if( array_key_exists( 'edit_posts', $data['capabilities'] ) && wp_validate_boolean( $data['capabilities']['edit_posts'] ) ): ?>
									<li><label>
									<?php printf(
										'<input class="wpuc-allow-role" %1$s id="role_%2$s" type="checkbox" value="%2$s" data-nonce="%3$s">',
										array_key_exists( 'add_channels', $data['capabilities'] ) && $data['capabilities']['add_channels'] ? 'checked' : '',
										esc_attr( $role ),
										wp_create_nonce( 'assign_role_cap_' . $role )
									); ?>

									<?php printf(
										'%s (%s)',
										$data['name'],
										$role
									); ?>
									</label></li>
								<?php endif;?>
							<?php endforeach; ?>
						</ul>
					</td>
				</tr>				

			</tbody>

		</table>

		<?php wp_nonce_field( 'update_wp_user_channel_security', 'update_wp_user_channel' );?>

		<?php submit_button(); ?>

	</form>
</div>