<?php
/**
 *
 * The List Channel template file
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      1.0.0
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
    exit;
}

$channels = WPUChannel()->get_channel_list();
?>
<div class="channel-list-container">

	<?php
	/**
	 *
	 * Fires before Channel List
	 * 
	 */
	do_action( 'wp_user_channel/channel_list/before' );

	if( $channels ){
		printf(
			'<ul class="channel-list list-group list-group-flush">%s</ul>',
			$channels
		);
	}else{
		printf(
			'<p>%s</p>',
			esc_html__( 'You have not created any channels yet.', 'wp-user-channel' )
		);
	}

	/**
	 *
	 * Fires after Channel List
	 * 
	 */
	do_action( 'wp_user_channel/channel_list/after' );

	?>
</div>