<?php
/**
 *
 * The Channels template file
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      1.0.0
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
    exit;
}

?>

<?php
/**
 *
 * Fires before page header
 * 
 */
do_action( 'streamtube/core/user/dashboard/page_header/before' );
?>
<div class="page-head mb-3 d-flex gap-3 align-items-center border-bottom">
    <?php
    /**
     *
     * Fires before heading
     * 
     */
    do_action( 'streamtube/core/user/dashboard/page_header/heading/before' );
    ?>		
	<h1 class="page-title h4">
        <?php
        /**
         *
         * Fires before heading
         * 
         */
        do_action( 'streamtube/core/user/dashboard/page_header/heading/inside/before' );
        ?> 		
		<?php esc_html_e( 'All Channels', 'streamtube-core' );?>
        <?php
        /**
         *
         * Fires after heading
         * 
         */
        do_action( 'streamtube/core/user/dashboard/page_header/heading/inside/after' );
        ?> 		
	</h1>	
    <?php
    /**
     *
     * Fires before heading
     * 
     */
    do_action( 'streamtube/core/user/dashboard/page_header/heading/after' );
    ?>	
</div>

<?php
/**
 *
 * Fires after page header
 * 
 */
do_action( 'streamtube/core/user/dashboard/page_header/after' );

/**
 *
 * Fires before page content
 * 
 */
do_action( 'streamtube/core/user/dashboard/page_content/before' );
?>

<div class="page-content">

	<?php 
	load_template( WP_USER_CHANNEL_PATH . 'partials/create-channel.php' );	
	
	load_template( WP_USER_CHANNEL_PATH . 'partials/channels.php' );	
	?>

</div>

<?php

/**
 *
 * Fires after page content
 * 
 */
do_action( 'streamtube/core/user/dashboard/page_content/after' );