(function( $ ) {
	'use strict';

	$(function() {

		if( $('body' ).hasClass( 'post-type-video' ) ){
			/**
			 * Auto insert generate image button
			 */
			var button = '';

			button = '<div class="metabox-wrap">';
				button += '<button type="button" id="button-generate-thumb-image" class="button button-primary">';
					button += streamtube.generate;
					button += '<span class="spinner"></span>';
				button += '</button>';
			button += '</div>';
			$( '#postimagediv' ).append( button );
		}	
	});

	$( document ).on( 'submit', 'form[name=streamtube-upgrade-form]', function(e){
		e.preventDefault();

		let form 		= $(this);
		let button 		= form.find( 'button[type=submit]' );
		var formData 	= new FormData(form[0]);

		var jqxhr = $.ajax({
			url 			: streamtube.ajax_url,
			data 			: formData,
			processData 	: false,
			contentType 	: false,
			type 			: 'POST',		
			beforeSend: function( jqXHR ) {
				button.attr( 'disabled', 'disabled' );
				form.find( '.spinner' ).addClass( 'is-active' );
			}
		});

		jqxhr.fail( function( jqXHR, textStatus, errorThrown ){
			alert( errorThrown ?? textStatus );
			button.removeAttr( 'disabled' );
			form.find( '.spinner' ).removeClass( 'is-active' );
		});

		jqxhr.done( function( data, textStatus, jqXHR ){
			if( data.success == false ){
				alert( data.data[0].message );
			}else{
				alert( data.data );
				form.closest( 'div.notice' ).remove();
			}
			button.removeAttr( 'disabled' );
			form.find( '.spinner' ).removeClass( 'is-active' );
		});
	} );
	
	/**
	 *
	 * Widget TabJS handler
	 *
	 * @since  1.0.0
	 * 
	 */
	$( document ).on( 'click', '.widget-content .widget-tabs a', function(e){

		e.preventDefault();

		var parent	=	$(this).closest( '.widget-tabs' );
		var href 	=	$(this).attr( 'href' );

		parent.find( '.nav-link' ).removeClass( 'active' );

		$(this).addClass( 'active' );
		

		parent.next().find( '.tab-pane' ).removeClass( 'active' );

		parent.next().find( href ).addClass( 'active' );

		parent.next().find( '.current-tab' ).val( href.replace( '#', '' ) );
	});

	/**
	 * Post Type selector
	 *
	 * @since  1.0.0
	 * 
	 */
	$( document ).on( 'change', '.widget-content select.post-type', function(e){

		var postType 	=	$(this).val();
		var parent 		=	$(this).closest( 'div.field-control' );

		parent.next().find( '.taxonomy' ).removeClass( 'active' );
		parent.next().find( '.taxonomy-' + postType ).addClass( 'active' );
	});

	/**
	 *
	 * Remove error class of the fields
	 *
	 * @sice 1.0.6
	 * 
	 */
	$( document ).on( 'change', '.metabox-wrap .regular-text', function(e){
		$(this).removeClass( 'error' );
	});

	/**
	 *
	 * Upload file button handler
	 * @since  1.0.0
	 * 
	 */
	$( document ).on( 'click', 'button.button-upload', function(e){
		e.preventDefault();

		var button 		= $(this);
		var mediaType 	= button.attr( 'data-media-type' );
		var mediaSource = button.attr( 'data-media-source' );

		var frame;
		
		// If the media frame already exists, reopen it.
		if ( frame ) {
			frame.open();
			return;
	    }
		
		// Create a new media frame
		frame = wp.media({	
			library: { type: mediaType },
			multiple: false  // Set to true to allow multiple files to be selected
		});	
		
		 // When an video is selected in the media frame...
	    frame.on( 'select', function() {
	    	
	    	// Get media attachment details from the frame state
	    	var attachment = frame.state().get('selection').first().toJSON();

	    	var attachment_id	=	attachment.id;
	    	var mime			=	attachment.mime;
	    	var subtype			=	attachment.subtype; // known as techorder.
	    	var url				=	attachment.url;

	    	var mediaId = '';

	    	if( mediaSource == 'url' ){
	    		mediaId = url;
	    	}
	    	else{
	    		mediaId = attachment_id;	
	    	}

	    	if( mediaType == 'image' ){

	    		var imgWrap = button
	    		.closest( '.field-group' )
				.find( '.placeholder-image' );
				imgWrap.removeClass( 'no-image' ).append( '<img src="'+mediaId+'">' );
	    	}

	    	button
	    	.closest( '.field-group' )
	    	.find( '.input-field' )
	    	.val( mediaId )
	    	.removeClass( 'error' );

	    });
	    
    	 // Finally, open the modal on click
        frame.open();		
	});

	$( document ).on( 'click', '.field-group .button-delete', function(e){
		var fieldGroup = $(this).closest( '.field-group' );
		fieldGroup.find( '.placeholder-image' ).addClass( 'no-image' );
		fieldGroup.find( 'img' ).remove();
		fieldGroup.find( '.input-field' ).val('');
	});

	/**
	 *
	 * Generate webp image
	 * 
	 */
	$( document ).on( 'click', '#button-generate-webp-image', function(e){
		e.preventDefault();

		var button = $(this);
		var mediaId = parseInt( $( '#streamtube-video-main-source' ).find( 'textarea[name=video_url]' ).val() );
		var postId = button.closest( 'form' ).find( 'input[name=post_ID]' ).val();

		if( isNaN( mediaId ) ){
			button.closest( 'form' ).find( 'textarea[name=video_url]' ).addClass( 'error' ).focus();
			button.closest( '.field-group' ).find( '.alert' ).remove();

            $('html, body').animate({
                scrollTop: $( '#streamtube-video-main-source' ).offset().top
            }, 1000 );

            button.after( '<div class="alert error">'+streamtube.cannot_generate_image+'</div>' );

			return false;
		}

		$.ajax( {
			url: streamtube.rest_url + '/generate-image',
			method: 'POST',
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'X-WP-Nonce', streamtube.nonce );

				button
				.attr( 'disabled', 'disabled' )
				.find( '.spinner' )
				.addClass( 'is-active' );

				button
				.closest( '.field-group' )
				.find( '.alert' )
				.remove();
			},
			data:{
				'mediaid' 		: mediaId,
				'parent'		: postId,
				'type'			: 'animated_image'
			}
		} ).done( function ( response ) {

			if( response.success == false ){
				button.after( '<div class="alert error">'+response.data[0].message+'</div>' );
			}else{
				button
				.closest( '.field-group' )
				.find( 'input[name=thumbnail_image_url_2]' )
				.val( response.data.thumbnail_url );

				button
				.closest( '.field-group' )
				.find( '.placeholder-image' )
				.append( '<img src="'+response.data.thumbnail_url+'">' );

				button
				.closest( '.field-group' )
				.find( '.placeholder-image' )
				.removeClass( 'no-image' );
			}

			button
			.removeAttr( 'disabled' )
			.find( '.spinner' )
			.removeClass( 'is-active' );

		} );

	} );

	/**
	 *
	 * Generate thumbnail image
	 * 
	 */
	$( document ).on( 'click', '#button-generate-thumb-image', function(e){
		e.preventDefault();
		var button = $(this);
		var wrapper = button.closest( '#postimagediv' );
		var mediaId = $( '#streamtube-video-main-source' ).find( 'textarea[name=video_url]' ).val();
		var postId = button.closest( 'form' ).find( 'input[name=post_ID]' ).val();

		if( mediaId == "" ){
			
			button.closest( 'form' ).find( 'textarea[name=video_url]' ).addClass( 'error' ).focus();

            $('html, body').animate({
                scrollTop: $( '#video-data' ).offset().top
            }, 1000 );

			return false;
		}

		$.ajax( {
			url: streamtube.rest_url + '/generate-image',
			method: 'POST',
			beforeSend: function ( xhr ) {
				xhr.setRequestHeader( 'X-WP-Nonce', streamtube.nonce );

				button
				.attr( 'disabled', 'disabled' )
				.find( '.spinner' )
				.addClass( 'is-active' );

				button
				.closest( '.metabox-wrap' )
				.find( '.alert' )
				.remove();				
			},
			data:{
				'mediaid'	: mediaId,
				'parent'	: postId,
				'type'		: 'image'
			}
		} ).done( function ( response ) {

			if( response.success == false ){
				var output = '';
				output += '<div class="alert error">';
					output += '<strong>'+response.data[0].code+': </strong>';
					output += response.data[0].message;
				output += '</div>';
				button.after( output );
			}

			if( response.success == true ){
				var imgTag = '<p class="hide-if-no-js"><a href="'+streamtube.admin_url+'media-upload.php?post_id='+postId+'&type=image&TB_iframe=1" id="set-post-thumbnail" class="thickbox">';
					imgTag += '<img src="'+ response.data.thumbnail_url +'">';
				imgTag += '</a></p>';

				imgTag += '<p class="hide-if-no-js"><a href="#" id="remove-post-thumbnail">'+streamtube.remove_featured_image+'</a></p>';

				wrapper.find( '.inside .hide-if-no-js' ).remove();
				wrapper.find( '.inside' ).prepend( imgTag );

				wrapper.find( '#_thumbnail_id' ).val( response.data.thumbnail_id );

			}

			button
			.removeAttr( 'disabled' )
			.find( '.spinner' )
			.removeClass( 'is-active' );
		} );
	});	

	$( document ).on( 'change', '.restrict-content-wrap #restrict_content_for', function(e){
		var value = $(this).val();

		var td = $(this).closest( 'td' );

		td.find( '.section-apply-for' ).hide();

		td.find( '#section-' + value ).show();

		if( $.inArray( value, [ 'roles', 'capabilities' ] ) !== -1 ){
			$( '#section-operator' ).show();
		}else{
			$( '#section-operator' ).hide();
		}
	});

	/**
	 *
	 * Ad Server select controler
	 * 
	 */
	$( document ).on( 'change', 'select#ad_server', function(e){
		var server = $(this).val();

		$( '.groups-ad_server' ).addClass( 'd-none' );

		$( '.groups-ad_server-' + server ).removeClass( 'd-none' );
	} );

	/**
	 *
	 * Ad Type select controler
	 * 
	 */
	$( document ).on( 'change', 'select#ad_type', function(e){
		var type = $(this).val();

		if( type == 'nonlinear' ){
			$( '.ad_type-nonlinear' ).removeClass( 'd-none' );
		}else{
			$( '.ad_type-nonlinear' ).addClass( 'd-none' );
		}

	} );

	/**
	 * ThickBox Add Ad_Tag button handler
	 */
	$( document ).on( 'click', '#button-add-ad_tag', function(e){
		e.preventDefault();

		var button 		= $(this);

		var wrapper 	= button.closest( '#add-ad-tags-wrap' );

		var adTagField 	= wrapper.find( 'select#ad_tag' );
		var adPlacement = wrapper.find( 'select#ad_placement' );
		var adPosition 	= wrapper.find( 'input#ad_position' );

		if( adTagField.val() == "" ){
			adTagField.focus();
			return false;
		}

		var adTagText 			= adTagField.find( 'option:selected' ).text();
		var adTagId 			= adTagField.val();
		var adTagType			= adTagField.find( 'option:selected' ).attr( 'data-ad-type' );

		var adPlacementText 	= adPlacement.find( 'option:selected' ).text();
		var adPlacementId 		= adPlacement.val();

		var adPositionVal 		= adPosition.val();

		var tagRow = '';

		tagRow += '<tr class="ad_tag_row" id="ad_tag_row'+adTagId+'">';

			tagRow += '<td class="ad_tag_index">#</td>';

			tagRow += '<td class="ad_tag_text">';
				tagRow += '<strong>'+adTagText+'</strong>';
				tagRow += '<input type="hidden" name="ad_schedule[ad_tags][id][]" value="'+ adTagId +'">';
				tagRow += '<input type="hidden" name="ad_schedule[ad_tags][placement][]" value="'+ adPlacementId +'">';
			tagRow += '</td>';

			tagRow += '<td class="ad_tag_type">';
				tagRow += adTagType;

				if( adPlacementId == 'preroll' ){
					tagRow += ' <strong>(start)</strong>';
				}

				if( adPlacementId == 'midroll' && adPositionVal ){
					tagRow += ' <strong>(' + adPositionVal + ')</strong>';
				}
				if( adPlacementId == 'postroll' ){
					tagRow += ' <strong>(end)</strong>';
				}

				tagRow += '<input type="text" class="regular-text field-ad_tag_position" name="ad_schedule[ad_tags][position][]" value="'+ adPositionVal +'">';				
			tagRow += '</td>';

			tagRow += '<td class="ad_tag_button">';
				tagRow += '<button type="button" class="button button-small button-delete">';
					tagRow += '<span class="dashicons dashicons-trash"></span>';
				tagRow += '</button>';
			tagRow += '</td>';
			
		tagRow += '</tr>';

		$( 'table#table-ad_tags-' + adPlacementId + ' tbody' ).append( tagRow );

		button.html( button.attr( 'data-text-added' ) );

	});

	$( document ).on( 'change', '#add-ad-tags-wrap select#ad_placement', function(e){
		var select 		= $(this);
		var adPlacement = select.val();

		if( adPlacement == 'midroll' ){
			select.closest( '.field-group' ).next().removeClass( 'd-none' );
		}else{
			select.closest( '.field-group' ).next().addClass( 'd-none' );
		}
	});

	/**
	 *
	 * Delete Ad Tag button handler
	 * 
	 */
	$( document ).on( 'click', '.table-ad_tags button.button-delete', function(e){
		if( confirm( streamtube.confirm_remove_ad ) === true ){
			$(this).closest( 'tr.ad_tag_row' ).remove();	
		}
	});

	/**
	 *
	 * VAST Importer button handler
	 *
	 */
	$( document ).on( 'click', 'button#import_vast', function(e){

		e.preventDefault();
		var button = $(this);

		$.ajax({
			url: streamtube.ajax_url,
			method: 'POST',
            data: {
                'url': $( '#ad_adtag_url' ).val(),
                'post_id' : $( '#post_ID' ).val(),
                'action': 'import_vast'
            },
            beforeSend: function() {
                button.addClass('disabled').attr( 'disabled', 'disabled');
            },            
			success: function( response ){
				if( response.success == true ){
					$( '#ad_adtag_url' ).val( response.data.ad_content );
					button.text( response.data.button );
				}else{
					alert( response.data );
					button.text( button.attr( 'data-button-text' ) );
				}

				button.removeClass('disabled').removeAttr( 'disabled' );
			}
		});
	});	

})( jQuery );
