(function( $ ) {
	'use strict';
	/**
	 *
	 * The Verify button handler
	 * 
	 */
	$( document ).on( 'click', 'button.button-verification', function(e){
		e.preventDefault();
		var button = $(this);
		var userId = button.attr( 'data-user-id' );

		button.attr( 'disabled', 'disabled' );

		$.post( streamtube.ajax_url, {
			action 		: 'verify_user',
			user_id		: userId,
			_wpnonce  	: streamtube._wpnonce
		}, function( response ){
			if( response.success === true ){
				return button.replaceWith( response.data.button );
			}

			if( streamtube.is_admin ){
				alert( response.data[0].message );
			}else{
				$.showToast( response.data, 'danger' );
			}

			button.removeAttr( 'disabled' );
		} );
	});

	/**
	 *
	 * The Deactivate/Reactivate button handler
	 * 
	 */
	$( document ).on( 'click', 'button.button-deactivate', function(e){
		e.preventDefault();
		var button = $(this);
		var userId = button.attr( 'data-user-id' );

		button.attr( 'disabled', 'disabled' );

		$.post( streamtube.ajax_url, {
			action 		: 'admin_deactivate_user',
			user_id		: userId,
			_wpnonce  	: streamtube._wpnonce
		}, function( response ){
			if( response.success === true ){
				return button.replaceWith( response.data.button );				
			}

			if( streamtube.is_admin ){
				alert( response.data[0].message );
			}else{
				$.showToast( response.data, 'danger' );
			}

			button.removeAttr( 'disabled' );
		} );
	});	
})( jQuery );	