<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$source = $args;
?>

<th scope="row" class="check-column p-1">
	<span class="badge bg-danger text-white count">
	</span>
</th>

<td data-colname="<?php esc_attr_e( 'Label', 'streamtube-core' ) ?>" class="title column-title column-primary">
	<?php printf(
		'<input type="text" class="regular-text" name="altsources[labels][]" value="%s">',
		esc_attr( $source['label'] )
	); ?>
	<button type="button" class="toggle-row">
		<span class="screen-reader-text">
			<?php esc_html_e( 'Show more details', 'streamtube-core' ) ?>
		</span>
	</button>
</td>

<td data-colname="<?php esc_attr_e( 'Source', 'streamtube-core' ) ?>">
	<div class="field-group">
		<div class="input-group">
			<?php printf(
				'<input class="input-field regular-text form-control text-track-field" type="text" name="altsources[sources][]" value="%s">',
				esc_attr( $source['source'] )
			); ?>

			<?php if ( current_user_can( 'administrator' ) || apply_filters( 'streamtube/core/altsource/wpmedia', false ) === true ) : ?>
				<button type="button" class="btn btn-secondary button button-secondary button-upload"
					data-media-type="video" data-media-source="id">
					<span class="dashicons dashicons-upload"></span>
				</button>
			<?php endif; ?>
		</div>
	</div>
</td>

<td data-colname="<?php esc_attr_e( 'Action', 'streamtube-core' ) ?>">
	<div class="d-flex">
		<button type="button" class="mb-3 me-3 button button-small btn btn-danger btn-sm source_remove p-1">
			<span class="dashicons dashicons-minus"></span>
		</button>
		<button type="button"
			class="mb-3 me-3 button button-small btn btn-primary button-primary btn-sm source_add p-1">
			<span class="dashicons dashicons-plus"></span>
		</button>
	</div>
</td>