<?php

/**
 * Fired during plugin activation
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Streamtube_Core_Activator {
	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {

		self::update_version();

		self::install_cron_hooks();

		self::flush_rewrite_rules();

		self::install_database();

		/**
		 *
		 * Fires on plugin activated
		 * 
		 */
		do_action( 'streamtube/core/activated' );
	}

	/**
	 *
	 * Update plugin version
	 *
	 * @since 1..0.9
	 * 
	 */
	private static function update_version() {
		update_option( 'streamtube_core_version', STREAMTUBE_CORE_VERSION );
	}

	/**
	 *
	 * flush_rewrite_rules()
	 * 
	 */
	private static function flush_rewrite_rules() {
		flush_rewrite_rules();
	}

	/**
	 *
	 * Add cron hooks
	 *
	 * @since 1.0.9
	 * 
	 */
	private static function install_cron_hooks() {
		$hooks = new Streamtube_Core_Cron();
		$hooks->add_hooks();
	}

	/**
	 *
	 * Install custom database
	 * 
	 */
	private static function install_database() {
		if ( class_exists( 'StreamTube_Core_Storage_DB' ) ) {
			StreamTube_Core_Storage_DB::install_db();
		}
	}
}
