<?php
/**
 * Define the modules functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * Define the profile functionality
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Streamtube_Core_Modules {

	function __construct() {
	}

	/**
	 *
	 * Modules initial
	 * 
	 */
	public function register() {
		do_action( 'streamtube/core/register_modules' );
	}

	/**
	 * Add a module to the global `$streamtube_modules` array.
	 * 
	 * @param string $id           The unique ID for the module.
	 * @param string $name         The name of the module.
	 * @param array  $capabilities An array of capabilities for the module.
	 */
	public static function add( $id = '', $name = '', $capabilities = array() ) {
		global $streamtube_modules;

		if ( ! $streamtube_modules ) {
			$streamtube_modules = array();
		}

		// Sanitize the ID.
		$id = sanitize_title( $id );

		if ( ! $id || ! is_string( $id ) ) {
			return;
		}

		if ( array_key_exists( $id, $streamtube_modules ) && $capabilities ) {
			// Merge new capabilities into the existing module.
			if ( ! isset( $streamtube_modules[ $id ]['capabilities'] ) ) {
				$streamtube_modules[ $id ]['capabilities'] = array();
			}

			$streamtube_modules[ $id ]['capabilities'] = array_merge(
				$streamtube_modules[ $id ]['capabilities'],
				$capabilities
			);
		} else {
			// Add a new module.
			$streamtube_modules[ $id ] = compact( 'name', 'capabilities' );
		}

		// Remove duplicate capabilities.
		$streamtube_modules[ $id ]['capabilities'] = array_unique( $streamtube_modules[ $id ]['capabilities'] );

		sort( $streamtube_modules[ $id ]['capabilities'] );
	}

	/**
	 *
	 * Register post type modules
	 * 
	 */
	public function add_post_types() {

		$post_types = get_post_types( array(
			'public' => true
		), 'objects' );

		foreach ( $post_types as $post_type => $object ) {

			$capabilities = (array) $object->cap;

			if ( in_array( 'read', $capabilities ) ) {
				unset( $capabilities[ array_search( 'read', $capabilities ) ] );
			}

			$capabilities = array_values( $capabilities );

			self::add(
				$post_type,
				sprintf( esc_html__( 'Post Type: %s', 'streamtube-core' ), $object->labels->name ),
				$capabilities
			);
		}
	}

	/**
	 *
	 * Register taxonomy modules
	 * 
	 */
	public function add_taxonomies() {
		$taxonomies = get_taxonomies( array(
			'public' => true
		), 'objects' );
		foreach ( $taxonomies as $tax => $object ) {
			self::add(
				$tax,
				sprintf( esc_html__( 'Taxonomy: %s', 'streamtube-core' ), $object->labels->name ),
				array_values( (array) $object->cap )
			);
		}
	}

}