<?php
/**
 * WP Term List Table
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class StreamTube_Core_Terms_List_Table extends WP_Terms_List_Table {

	public $post_type;

	function __construct( $args = array() ) {

		$this->post_type = $args['post_type'];

		parent::__construct( $args );
	}

	public function get_taxonomy_object() {
		return get_taxonomy( $this->screen->taxonomy );
	}

	/**
	 * @param WP_Term $tag Term object.
	 * @return string
	 */
	public function column_posts( $tag ) {

		$count = number_format_i18n( $tag->count );

		$tax = get_taxonomy( $this->screen->taxonomy );

		$ptype_object = get_post_type_object( $this->post_type );

		if ( ! $ptype_object->show_ui_frontend ) {
			return $count;
		}

		$args = array(
			'taxonomy' => $tax->name,
			'term_id'  => $tag->term_id,
		);

		if ( 'attachment' === $this->post_type ) {
			return "<a href='" . esc_url( add_query_arg( $args, 'upload.php' ) ) . "'>$count</a>";
		}

		$url = trailingslashit( get_author_posts_url( get_current_user_id() ) ) . 'dashboard/' . $this->post_type;

		return "<a href='" . esc_url( add_query_arg( $args, $url ) ) . "'>$count</a>";
	}

	/**
	 */
	public function prepare_items() {

		$taxonomy = $this->screen->taxonomy;

		$tags_per_page = $this->get_items_per_page( "edit_{$taxonomy}_per_page" );

		if ( 'post_tag' === $taxonomy ) {
			/**
			 * Filters the number of terms displayed per page for the Tags list table.
			 *
			 * @since 2.8.0
			 *
			 * @param int $tags_per_page Number of tags to be displayed. Default 20.
			 */
			$tags_per_page = apply_filters( 'edit_tags_per_page', $tags_per_page );

			/**
			 * Filters the number of terms displayed per page for the Tags list table.
			 *
			 * @since 2.7.0
			 * @deprecated 2.8.0 Use {@see 'edit_tags_per_page'} instead.
			 *
			 * @param int $tags_per_page Number of tags to be displayed. Default 20.
			 */
			$tags_per_page = apply_filters_deprecated( 'tagsperpage', array( $tags_per_page ), '2.8.0', 'edit_tags_per_page' );
		} elseif ( 'category' === $taxonomy ) {
			/**
			 * Filters the number of terms displayed per page for the Categories list table.
			 *
			 * @since 2.8.0
			 *
			 * @param int $tags_per_page Number of categories to be displayed. Default 20.
			 */
			$tags_per_page = apply_filters( 'edit_categories_per_page', $tags_per_page );
		}

		$search = ! empty( $_REQUEST['s'] ) ? trim( wp_unslash( $_REQUEST['s'] ) ) : '';

		$args = array(
			'taxonomy'   => $taxonomy,
			'search'     => $search,
			'page'       => $this->get_pagenum(),
			'number'     => $tags_per_page,
			'hide_empty' => 0,
		);

		if ( ! empty( $_REQUEST['orderby'] ) ) {
			$args['orderby'] = trim( wp_unslash( $_REQUEST['orderby'] ) );
		}

		if ( ! empty( $_REQUEST['order'] ) ) {
			$args['order'] = trim( wp_unslash( $_REQUEST['order'] ) );
		}

		$args['offset'] = ( $args['page'] - 1 ) * $args['number'];

		// Save the values because 'number' and 'offset' can be subsequently overridden.
		$this->callback_args = $args;

		if ( is_taxonomy_hierarchical( $taxonomy ) && ! isset( $args['orderby'] ) ) {
			// We'll need the full set of terms then.
			$args['number'] = 0;
			$args['offset'] = $args['number'];
		}

		$args = apply_filters( 'streamtube/core/terms_list_table/args', $args );

		$this->items = get_terms( $args );

		$this->set_pagination_args(
			array(
				'total_items' => wp_count_terms(
					array(
						'taxonomy' => $taxonomy,
						'search'   => $search,
					)
				),
				'per_page'    => $tags_per_page,
			)
		);
	}

	public function output_inline_edit() {

		$output = '';

		ob_start();

		$this->inline_edit();

		$output = ob_get_clean();

		$field = '<input type="hidden" name="is_frontend" value="on" />';

		$output = preg_replace( '/(<div class="inline-edit-save submit">)/', '$1' . $field, $output );

		if ( $this->post_type !== 'post' ) {
			$output = preg_replace(
				'/<input\s+type="hidden"\s+name="post_type"\s*[^>]*>/i',
				'<input type="hidden" name="post_type" value="' . $this->post_type . '">',
				$output
			);
		}

		echo $output;
	}

	/**
	 * Enqueue admin js
	 */
	public function enqueue_scripts() {
		if ( current_user_can( $this->get_taxonomy_object()->cap->edit_terms ) && ! isset( $_REQUEST['tag_ID'] ) ) {
			wp_enqueue_script( 'wp-admin-tags' );
			wp_enqueue_script( 'wp-inline-edit-tax' );
		}
	}
}