<?php
/**
 * Taxonomy List
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      2.2.1
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      2.2.1
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Streamtube_Core_Advanced_Nav_Elementor extends \Elementor\Widget_Base {
	public function get_name() {
		return 'streamtube-advanced-nav';
	}

	public function get_title() {
		return esc_html__( 'Advanced Navigation', 'streamtube-core' );
	}


	public function get_keywords() {
		return array( 'menu', 'nav', 'navigation', 'streamtube' );
	}

	public function get_categories() {
		return array( 'streamtube' );
	}

	private function get_wp_menus() {

		$_menus = array();

		$menus = wp_get_nav_menus();

		if ( ! $menus ) {
			return array();
		}

		foreach ( $menus as $menu ) {
			$_menus[ $menu->term_id ] = $menu->name;
		}

		return $_menus;
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section-appearance',
			array(
				'label' => esc_html__( 'Appearance', 'streamtube-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT
			)
		);

		$this->add_control(
			'title',
			array(
				'label' => esc_html__( 'Title', 'streamtube-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT
			)
		);

		$this->add_control(
			'nav_menu',
			array(
				'label'   => esc_html__( 'Menu', 'streamtube-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'options' => $this->get_wp_menus()
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$instance = $this->get_settings_for_display();

		the_widget( 'Streamtube_Core_Widget_Nav', $instance, array(
			'before_widget' => '<div class="widget widget-elementor advanced-nav-widget streamtube-widget">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title-wrap"><h2 class="widget-title d-flex align-items-center">',
			'after_title'   => '</h2></div>'
		) );
	}
}

if ( defined( 'ELEMENTOR_VERSION' ) && version_compare( ELEMENTOR_VERSION, '3.5.0', '<' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Streamtube_Core_Advanced_Nav_Elementor() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register( new Streamtube_Core_Advanced_Nav_Elementor() );
}