<?php
/**
 *
 * Filter functions
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 *
 * Filter checklist args
 * Set checked_ontop true
 * 
 * @param  array $args
 * @return array $args
 * 
 */
function streamtube_core_filter_wp_terms_checklist( $args ) {
	$args = array_merge( $args, array(
		'checked_ontop' => false
	) );

	return apply_filters( 'streamtube_core_filter_wp_terms_checklist', $args );
}

/**
 * Hashes the file name if it is an image file.
 *
 * This function takes a file name, checks if it has an image extension (jpg, png, gif, webp),
 * and if so, hashes the file name using MD5 along with a unique identifier. The hashed file name
 * is returned with the original extension. If the file is not an image, the original file name is returned.
 *
 * @param string $filename The original file name to be hashed.
 * @return string The hashed file name with the original extension if it is an image, otherwise the original file name.
 */
function streamtube_core_hash_file_name( $filename, $exts = array() ) {

	$new_name = '';
	$info     = pathinfo( $filename );
	$ext      = empty( $info['extension'] ) ? '' : '.' . $info['extension'];

	$exts = $exts ? $exts : array( '.jpg', '.png', '.gif', '.webp' );

	if ( in_array( $ext, $exts ) ) {
		$name     = basename( $filename, $ext );
		$new_name = md5( $name . uniqid() ) . $ext;
	} else {
		$new_name = $filename;
	}

	return apply_filters( 'streamtube_core_hash_file_name', $new_name, $filename, $exts );
}