<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define the upload video rest functionality.
 *
 * @since      1.0.6
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
class StreamTube_Core_Rest_Embed_Controller extends StreamTube_Core_Rest_API{

    protected $path     =   '/embed';

    /**
     * @since 1.0.6
     */
    public function rest_api_init(){

        register_rest_route(
            "{$this->namespace}{$this->version}",
            $this->path, 
            array(
                'methods'   =>  WP_REST_Server::CREATABLE,
                'callback'  =>  array( $this , 'create_embed' ),
                'args'      =>  array(
                    'source' =>  array(
                        'validate_callback' => function( $param, $request, $key ) {
                            return is_string( $param );
                        }
                    ),
                    'post_status' =>  array(
                        'validate_callback' => function( $param, $request, $key ) {
                            return is_string( $param );
                        }
                    )                    
                ),
                'permission_callback'   =>  function( $request ){
                    return Streamtube_Core_Permission::can_embed();
                }
            )
        ); 
    }

    /**
     *
     * Get Post instance
     * 
     */
    private function get_instance(){
        return $GLOBALS['streamtube']->get()->post;
    }

    /**
     *
     * Do upload file
     * 
     */
    public function create_embed( $request ){

        $response = $this->get_instance()->import_embed( $request['source'], $request['post_status'] );
        
        if( is_wp_error( $response ) ){
            wp_send_json_error( $response );
        }

        wp_send_json_success( $response );
    }
}
