<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define the rest functionality.
 *
 *
 * @since      1.0.6
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
class StreamTube_Core_Post_Rest_API{

	public function rest_api_init(){

		register_rest_field( 
			'video', 
			'playbacks', 
			array( 
				'get_callback'	=>	array( $this, 'get_video_source_field' ) 
			) 
		);

	}

    /**
     *
     * Get Post instance
     * 
     */
    private function get_instance(){
        return $GLOBALS['streamtube']->get()->post;
    }	

    /**
     *
     * Playbacks field callback
     * 
     */
	public function get_video_source_field( $object ){

		$source = $this->get_instance()->get_source( $object['id'] );

		if( wp_attachment_is( 'audio', $source ) || wp_attachment_is( 'video', $source ) ){
			$source = wp_get_attachment_url( $source );
		}

		/**
		 *
		 * Filter source
		 *
		 * @param mixed $source
		 * @param array WP_Post $object
		 * 
		 */
		return apply_filters( 'streamtube/core/rest/video/source', $source, $object );
	}
}