<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Define the upload video rest functionality.
 *
 * @since      1.0.6
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
class StreamTube_Core_Rest_Upload_Controller extends StreamTube_Core_Rest_API{

    protected $path     =   '/upload';

    /**
     * @since 1.0.6
     */
    public function rest_api_init(){

        register_rest_route(
            "{$this->namespace}{$this->version}",
            $this->path, 
            array(
                'methods'   =>  WP_REST_Server::CREATABLE,
                'callback'  =>  array( $this , 'create_upload' ),
                'args'      =>  array(
                    'file' =>  array(
                        'validate_callback' => function( $param, $request, $key ) {
                            return is_array( $param );
                        }
                    )
                ),
                'permission_callback'   =>  function( $request ){
                    return Streamtube_Core_Permission::can_upload();
                }
            )
        ); 
    }

    /**
     *
     * Get Post instance
     * 
     */
    private function get_instance(){
        return $GLOBALS['streamtube']->get()->post;
    }

    /**
     *
     * Do upload file
     * 
     */
    public function create_upload( $request ){

        $response = $this->get_instance()->upload_video();
        
        if( is_wp_error( $response ) ){
            wp_send_json_error( $response, 403 );
        }

        wp_send_json_success( array(
            'post'  =>  $response
        ) );
    }
}
