<?php

/**
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Streamtube_Core_Upgrade_40 {

	public static function init() {
		add_filter(
			'streamtube/core/should_upgrade_database',
			array( __CLASS__, 'upgrade_database_40' )
		);

		add_action(
			'streamtube/core/do_upgrade_database',
			array( __CLASS__, 'upgrade_admin_capabilities' )
		);

		add_action(
			'streamtube/core/do_upgrade_database',
			array( __CLASS__, 'upgrade_author_capabilities' )
		);

		add_action(
			'streamtube/core/did_upgrade_database',
			array( __CLASS__, 'did_upgrade_database_40' )
		);
	}

	/**
	 *
	 * Hooks into `streamtube/core/should_upgrade_database`
	 * To upgrade 40
	 *
	 * Cancel if `upgrade_database_40` found
	 *
	 */
	public static function upgrade_database_40() {
		return ! get_option( 'upgrade_database_40' );
	}

	/**
	 *
	 * Hooks into `streamtube/core/should_upgrade_database`
	 * To upgrade 40
	 *
	 * Cancel if `upgrade_database_40` found
	 *
	 */
	public static function did_upgrade_database_40() {
		return update_option( 'upgrade_database_40', current_time( 'timestamp' ) );
	}

	/**
	 *
	 * Upgrade admin capabilies
	 *
	 * Add all available capabilities for administrator role.
	 *
	 * Hooks into `streamtube/core/do_upgrade_database` action
	 *
	 */
	public static function upgrade_admin_capabilities() {
		global $streamtube_modules;

		$administrator = get_role( 'administrator' );

		foreach ( $streamtube_modules as $module => $value ) {
			if ( $value['capabilities'] ) {
				for ( $i = 0; $i < count( $value['capabilities'] ); $i++ ) {
					$administrator->add_cap( $value['capabilities'][$i] );
				}
			}
		}
	}

	/**
	 * Adds editable capabilities for author roles.
	 *
	 */
	public static function upgrade_author_capabilities() {

		if ( ! post_type_exists( 'video' ) ) {
			return;
		}

		$capabilities = get_post_type_object( 'video' )->cap;

		$author = get_role( 'author' );

		$author->add_cap( $capabilities->delete_posts );
		$author->add_cap( $capabilities->delete_published_posts );
		$author->add_cap( $capabilities->edit_posts );
		$author->add_cap( $capabilities->edit_published_posts );
	}
}

if ( is_admin() ) {
	Streamtube_Core_Upgrade_40::init();
}