<?php
/**
 * Define Advanced Nav widget
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Streamtube_Core_Widget_Nav extends WP_Widget {

	/**
	 * {@inheritDoc}
	 * @see WP_Widget::__construct()
	 */
	function __construct() {

		parent::__construct(
			'advanced-nav-widget',
			esc_html__( '[StreamTube] Advanced Navigation', 'streamtube-core' ),
			array(
				'classname' => 'advanced-nav-widget streamtube-widget'
			)
		);
	}

	/**
	 * Register this widget
	 */
	public static function register() {
		register_widget( __CLASS__ );
	}

	public function widget( $args, $instance ) {
		$instance = wp_parse_args( $instance, array(
			'title'    => '',
			'nav_menu' => ''
		) );

		if ( ! $instance['nav_menu'] ) {
			return;
		}

		$default_title = __( 'Menu' );

		$nav_menu = trim( $instance['nav_menu'] );

		$instance['title'] = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );

		echo $args['before_widget'];

		if ( $instance['title'] ) {
			echo $args['before_title'] . $instance['title'] . $args['after_title'];
		}

		$format = current_theme_supports( 'html5', 'navigation-widgets' ) ? 'html5' : 'xhtml';

		/**
		 * Filters the HTML format of widgets with navigation links.
		 *
		 * @since 5.5.0
		 *
		 * @param string $format The type of markup to use in widgets with navigation links.
		 *                       Accepts 'html5', 'xhtml'.
		 */
		$format = apply_filters( 'navigation_widgets_format', $format );

		if ( 'html5' === $format ) {
			// The title may be filtered: Strip out HTML and make sure the aria-label is never empty.
			$title      = trim( strip_tags( $instance['title'] ) );
			$aria_label = $title ? $title : $default_title;

			$nav_menu_args = array(
				'fallback_cb'          => 'WP_Bootstrap_Navwalker::fallback',
				'walker'               => new WP_Bootstrap_Navwalker(),
				'menu'                 => $nav_menu,
				'container'            => 'nav',
				'container_class'      => 'main-nav float-nav ',
				'menu_class'           => 'nav flex-column secondary-nav',
				'container_aria_label' => $aria_label,
				'items_wrap'           => '<ul id="%1$s" class="%2$s">%3$s</ul>'
			);
		} else {
			$nav_menu_args = array(
				'fallback_cb' => '',
				'menu'        => $nav_menu,
			);
		}

		/**
		 * Filters the arguments for the Navigation Menu widget.
		 *
		 * @since 4.2.0
		 * @since 4.4.0 Added the `$instance` parameter.
		 *
		 * @param array   $nav_menu_args {
		 *     An array of arguments passed to wp_nav_menu() to retrieve a navigation menu.
		 *
		 *     @type callable|bool $fallback_cb Callback to fire if the menu doesn't exist. Default empty.
		 *     @type mixed         $menu        Menu ID, slug, or name.
		 * }
		 * @param WP_Term $nav_menu      Nav menu object for the current menu.
		 * @param array   $args          Display arguments for the current widget.
		 * @param array   $instance      Array of settings for the current widget.
		 */
		wp_nav_menu( apply_filters( 'streamtube/core/widget/nav_menu_args', $nav_menu_args, $nav_menu, $args, $instance ) );

		echo $args['after_widget'];
	}

	/**
	 * {@inheritDoc}
	 * @see WP_Widget::update()
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		if ( ! empty( $new_instance['title'] ) ) {
			$instance['title'] = sanitize_text_field( $new_instance['title'] );
		}
		if ( ! empty( $new_instance['nav_menu'] ) ) {
			$instance['nav_menu'] = (int) $new_instance['nav_menu'];
		}
		return $instance;
	}

	public function form( $instance ) {
		$instance = wp_parse_args( $instance, array(
			'title'    => '',
			'nav_menu' => ''
		) );
		$menus    = wp_get_nav_menus();
		?>
		<div class="field-control">
			<?php printf(
				'<label for="%s">%s</label>',
				esc_attr( $this->get_field_id( 'title' ) ),
				esc_html__( 'Title', 'streamtube-core' )
			); ?>

			<?php printf(
				'<input type="text" class="widefat" id="%s" name="%s" value="%s" />',
				esc_attr( $this->get_field_id( 'title' ) ),
				esc_attr( $this->get_field_name( 'title' ) ),
				esc_attr( $instance['title'] )

			); ?>
		</div>

		<div class="field-control">
			<p>
				<label for="<?php echo $this->get_field_id( 'nav_menu' ); ?>"><?php _e( 'Select Menu:' ); ?></label>
			</p>
			<select class="widefat" id="<?php echo $this->get_field_id( 'nav_menu' ); ?>"
				name="<?php echo $this->get_field_name( 'nav_menu' ); ?>">
				<option value="0"><?php _e( '&mdash; Select &mdash;' ); ?></option>
				<?php foreach ( $menus as $menu ) : ?>
					<option value="<?php echo esc_attr( $menu->term_id ); ?>" <?php selected( $instance['nav_menu'], $menu->term_id ); ?>>
						<?php echo esc_html( $menu->name ); ?>
					</option>
				<?php endforeach; ?>
			</select>
		</div>
		<?php
	}
}