<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/public
 * @author     phpface <nttoanbrvt@gmail.com>
 */
class Streamtube_Core_Public {

	public $videojs_version = 8;

	/**
	 *
	 * Get videojs version
	 * 
	 * @return int|string
	 */
	public function get_videojs_version() {
		return apply_filters(
			'streamtube/core/videojs_version',
			get_option( 'player_version', $this->videojs_version )
		);
	}

	/**
	 *
	 * Get videojs assets
	 * 
	 */
	public function get_videojs_assets( $file = '' ) {

		$version = $this->get_videojs_version();

		return sprintf(
			'assets/vendor/video.js%s/%s',
			$version != 8 ? '' : $version,
			$file
		);
	}

	/**
	 *
	 * Enqueue videojs assets
	 * 
	 */
	public function enqueue_videojs() {
		wp_register_style(
			'videojs',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'video-js.min.css' ),
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'video-js.min.css' ) ),
			'all'
		);

		if ( "" != $skin_css = get_option( 'player_skin_css' ) ) {
			if ( ! did_action( 'custom_videojs_css_loaded' ) ) {
				wp_add_inline_style( 'videojs', $skin_css );
				do_action( 'custom_videojs_css_loaded' );
			}
		}

		wp_register_style(
			'videojs-theme-forest',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'themes/forest/index.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'themes/forest/index.css' ) ),
			'all'
		);

		wp_register_style(
			'videojs-theme-city',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'themes/city/index.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'themes/city/index.css' ) ),
			'all'
		);

		wp_register_style(
			'videojs-theme-fantasy',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'themes/fantasy/index.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'themes/fantasy/index.css' ) ),
			'all'
		);

		wp_register_style(
			'videojs-theme-sea',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'themes/sea/index.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'themes/sea/index.css' ) ),
			'all'
		);

		wp_register_style(
			'videojs-ima',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs.ima.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs.ima.css' ) ),
			'all'
		);

		wp_register_style(
			'videojs-contrib-ads',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-contrib-ads.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-contrib-ads.css' ) ),
			'all'
		);

		wp_register_style(
			'videojs-xr',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-xr.css' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-xr.css' ) ),
			'all'
		);

		wp_register_style(
			'streamtube-player',
			plugin_dir_url( __FILE__ ) . 'assets/css/player.css',
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/css/player.css' ),
			'all'
		);

		wp_register_script(
			'videojs',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'video.min.js' ),
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'video.min.js' ) ),
			true
		);

		if ( "" != $player_language = get_option( 'player_language' ) ) {
			wp_register_script(
				'videojs-language',
				plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'lang/' . sanitize_file_name( $player_language ) . '.js' ),
				array( 'videojs' ),
				filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'lang/' . sanitize_file_name( $player_language ) . '.js' ) ),
				true
			);
		}

		if ( version_compare( $this->get_videojs_version(), '8', '<' ) ) {
			wp_register_script(
				'videojs-contrib-quality-levels',
				plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-contrib-quality-levels.min.js' ),
				array( 'videojs' ),
				filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-contrib-quality-levels.min.js' ) ),
				true
			);
		}

		wp_register_script(
			'videojs-hls-quality-selector',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-hls-quality-selector.min.js' ),
			version_compare( $this->get_videojs_version(), '8', '<' ) ? array( 'videojs', 'videojs-contrib-quality-levels' ) : array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-hls-quality-selector.min.js' ) ),
			true
		);

		wp_register_script(
			'videojs-youtube',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'youtube.min.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'youtube.min.js' ) ),
			true
		);

		wp_register_script(
			'videojs-contrib-ads',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-contrib-ads.min.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-contrib-ads.min.js' ) ),
			true
		);

		wp_register_script(
			'ima3sdk',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'imasdk.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'imasdk.js' ) ),
			true
		);

		wp_register_script(
			'videojs-ima',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs.ima.min.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs.ima.min.js' ) ),
			true
		);

		wp_register_script(
			'videojs-hotkeys',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs.hotkeys.min.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs.hotkeys.min.js' ) ),
			true
		);

		wp_register_script(
			'videojs-landscape-fullscreen',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-landscape-fullscreen.min.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-landscape-fullscreen.min.js' ) ),
			true
		);

		wp_register_script(
			'videojs-xr',
			plugin_dir_url( __FILE__ ) . $this->get_videojs_assets( 'videojs-xr.min.js' ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . $this->get_videojs_assets( 'videojs-xr.min.js' ) ),
			true
		);

		wp_register_script(
			'player',
			plugin_dir_url( __FILE__ ) . sprintf( 'assets/js/player%s.js', $this->get_videojs_version() ),
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . sprintf( 'assets/js/player%s.js', $this->get_videojs_version() ) ),
			true
		);

	}

	/**
	 *
	 * Enqueue WP Core scripts
	 * 
	 */
	public function enqueue_wp_scripts() {

		global $wp_locale, $wp_query;


		wp_enqueue_style(
			'streamtube-wp-common',
			plugin_dir_url( __FILE__ ) . 'assets/css/common.css',
			array( 'bootstrap' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/css/common.css' )
		);

		if ( isset( $wp_query->query_vars['dashboard'] ) && is_user_logged_in() ) {

			wp_add_inline_script(
				'jquery',
				'var ajaxurl = "' . esc_js( admin_url( 'admin-ajax.php' ) ) . '", 
			    pagenow = "' . esc_js( streamtube_get_current_screen() ) . '", 
			    adminpage = "' . esc_js( $_SERVER['REQUEST_URI'] ) . '", 
			    typenow = "' . esc_js( $_SERVER['REQUEST_URI'] ) . '", 
			    thousandsSeparator = "' . esc_js( $wp_locale->number_format['thousands_sep'] ) . '",
			    decimalPoint = "' . esc_js( $wp_locale->number_format['decimal_point'] ) . '",
			    isRtl = "' . (int) is_rtl() . '";',
				'before'
			);

			wp_enqueue_style( 'wp-admin-forms', admin_url( 'css/forms.min.css' ), array( 'bootstrap' ) );
			wp_enqueue_style( 'admin-list-tables', admin_url( 'css/list-tables.min.css' ), array( 'bootstrap' ) );
			wp_enqueue_script( 'wp-i18n', home_url( '/wp-includes/js/dist/i18n.min.js' ), array( 'bootstrap' ) );
		}

		// Post Type
		//wp_enqueue_script( 'wp-lists' );
		wp_register_script( 'wp-tags-box', admin_url( 'js/tags-box.min.js' ) );
		wp_register_script( 'wp-tags-suggest', admin_url( 'js/tags-suggest.min.js' ) );
		wp_register_script( 'wp-inline-edit-post', admin_url( 'js/inline-edit-post.min.js' ), array( 'wp-lists' ) );
		wp_register_script( 'wp-admin-common', admin_url( 'js/common.min.js' ) );

		// Taxonomy     
		wp_register_script( 'wp-admin-tags', admin_url( 'js/tags.min.js' ) );
		wp_register_script( 'wp-inline-edit-tax', admin_url( 'js/inline-edit-tax.min.js' ) );

		// Comments
		//wp_enqueue_script( 'wp-lists' );
		wp_register_script( 'jquery.query', '/wp-includes/js/jquery/jquery.query.js' );
		wp_register_script( 'wp-admin-comments', admin_url( 'js/edit-comments.min.js' ), array( 'wp-lists' ) );

		// Metabox
		wp_register_script( 'clipboard', home_url( '/wp-includes/js/clipboard.min.js' ) );
		wp_register_script( 'word-count', admin_url( 'js/word-count.min.js' ) );
		wp_register_script( 'wp-postbox', admin_url( 'js/postbox.min.js' ), array( 'wp-i18n', 'jquery-ui-sortable', 'clipboard' ) );
		wp_register_script( 'wp-admin-post', admin_url( 'js/post.min.js' ), array( 'word-count', 'wp-i18n', 'jquery-ui-sortable', 'clipboard' ) );
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		$this->enqueue_videojs();

		$this->enqueue_wp_scripts();

		wp_enqueue_style(
			'placeholder-loading',
			plugin_dir_url( __FILE__ ) . 'assets/css/placeholder-loading.min.css',
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/css/placeholder-loading.min.css' )
		);

		wp_enqueue_style(
			'select2',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/select2/select2.min.css',
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/select2/select2.min.css' )
		);

		wp_register_style(
			'cropperjs',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/cropper/cropper.min.css',
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/cropper/cropper.min.css' ),
			'all'
		);

		wp_enqueue_style(
			'slick',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/slick/slick.css',
			array(),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/slick/slick.css' ),
			'all'
		);

		wp_enqueue_style(
			'slick-theme',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/slick/slick-theme.css',
			array( 'slick' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/slick/slick-theme.css' ),
			'all'
		);

		wp_register_style(
			'lightbox',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/lightbox2/css/lightbox.min.css',
			array( 'bootstrap' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/slick/slick-theme.css' ),
			'all'
		);

		$custom_css = '';

		foreach ( wp_roles()->roles as $key => $value ) {
			if ( "" != $color = get_option( 'role_badge_' . $key, '#6c757d' ) ) {
				$custom_css .= sprintf(
					'.user-roles .user-role.role-%s{background: %s!important}',
					$key,
					$color
				);
			}
		}

		wp_add_inline_style( 'streamtube-style', $custom_css );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		wp_enqueue_script( 'heartbeat' );

		if ( is_user_logged_in() && ! is_embed() ) {
			wp_enqueue_editor();
			wp_enqueue_script( 'wp-ajax-response' );
		}

		if ( current_user_can( 'administrator' ) ) {
			wp_enqueue_script(
				'streamtube-core-user',
				trailingslashit( STREAMTUBE_CORE_ADMIN_URL ) . 'assets/js/user.js',
				array( 'jquery' ),
				filemtime( trailingslashit( STREAMTUBE_CORE_ADMIN ) . 'assets/js/user.js' ),
				true
			);
		}

		wp_enqueue_script(
			'select2',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/select2/select2.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/select2/select2.min.js' ),
			true
		);

		$this->enqueue_videojs();

		wp_register_script(
			'cropperjs',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/cropper/cropper.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/cropper/cropper.min.js' ),
			true
		);

		wp_enqueue_script(
			'slick',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/slick/slick.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/slick/slick.min.js' ),
			true
		);

		wp_enqueue_script(
			'jquery.scrolling',
			plugin_dir_url( __FILE__ ) . 'assets/js/jquery.scrolling.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/jquery.scrolling.js' ),
			true
		);

		wp_enqueue_script(
			'autosize',
			plugin_dir_url( __FILE__ ) . 'assets/js/autosize.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/autosize.min.js' ),
			true
		);

		wp_register_script(
			'bootstrap-masonry.pkgd',
			plugin_dir_url( __FILE__ ) . 'assets/js/masonry.pkgd.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/masonry.pkgd.min.js' ),
			true
		);

		wp_enqueue_script(
			'typeahead',
			plugin_dir_url( __FILE__ ) . 'assets/js/typeahead.js',
			array( 'jquery', 'bootstrap' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/typeahead.js' ),
			true
		);

		wp_register_script(
			'lightbox',
			plugin_dir_url( __FILE__ ) . 'assets/vendor/lightbox2/js/lightbox.min.js',
			array( 'jquery', 'bootstrap' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/vendor/lightbox2/js/lightbox.min.js' ),
			true
		);

		wp_register_script(
			'jquery.countdown',
			plugin_dir_url( __FILE__ ) . 'assets/js/jquery.countdown.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/jquery.countdown.min.js' ),
			true
		);

		wp_register_script(
			'countdown.upcoming',
			plugin_dir_url( __FILE__ ) . 'assets/js/upcoming.js',
			array( 'jquery', 'jquery.countdown' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/upcoming.js' ),
			true
		);

		wp_enqueue_script(
			'streamtube-core-functions',
			plugin_dir_url( __FILE__ ) . 'assets/js/functions.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/functions.js' ),
			true
		);

		wp_register_script(
			'streamtube-core-permission',
			plugin_dir_url( __FILE__ ) . 'assets/js/permission.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/permission.js' ),
			true
		);

		if ( is_user_logged_in() && current_user_can( 'upload_files' ) ) {
			wp_enqueue_script(
				'tus',
				plugin_dir_url( __FILE__ ) . 'assets/js/tus.min.js',
				array( 'jquery' ),
				filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/tus.min.js' ),
				true
			);
		}

		wp_enqueue_script(
			'streamtube-core-scripts',
			plugin_dir_url( __FILE__ ) . 'assets/js/public.js',
			array( 'jquery', 'streamtube-core-functions' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/public.js' ),
			true
		);

		$jsvars = array(
			'is_admin'                       => is_admin(),
			'ajax_spinner'                   => true,
			'home_url'                       => home_url( '/' ),
			'rest_url'                       => esc_url_raw( rest_url( 'streamtube/v1' ) ),
			'nonce'                          => wp_create_nonce( 'wp_rest' ),
			'ajaxUrl'                        => admin_url( 'admin-ajax.php' ),
			'ajax_url'                       => admin_url( 'admin-ajax.php' ),
			'_wpnonce'                       => wp_create_nonce( '_wpnonce' ),
			'media_form'                     => wp_create_nonce( 'media-form' ),
			'chunks_nonce'                   => wp_create_nonce( 'chunks_nonce' ),
			'chunkUpload'                    => class_exists( 'BigFileUploads' ) ? 'on' : 'off',
			'sliceSize'                      => (int) get_option( 'chunk_size', 10240 ),
			'restRootUrl'                    => esc_url_raw( rest_url() ),
			'cart_url'                       => function_exists( 'wc_get_cart_url' ) ? wc_get_cart_url() : '',
			'video_extensions'               => wp_get_video_extensions(),
			'max_upload_size'                => (int) wp_max_upload_size(),
			'max_number_file'                => (int) streamtube_core_get_max_upload_files(),
			'max_number_file_error'          => sprintf(
				esc_html__( 'Maximum number of concurrent uploads: %s', 'streamtube-core' ),
				number_format_i18n( (int) streamtube_core_get_max_upload_files(), 0 )
			),
			'incorrect_image'                => esc_html__( 'Incorrect file type, please choose an image file.', 'streamtube-core' ),
			'can_upload_video'               => current_user_can( 'edit_posts' ),
			'can_upload_video_error_message' => esc_html__( 'Sorry, You do not have permission to upload video, please contact administrator.', 'streamtube-core' ),
			'invalid_file_format'            => esc_html__( 'Invalid file format.', 'streamtube-core' ),
			'exceeds_file_size'              => sprintf(
				esc_html__( 'The {filename} file size {size}MB exceeds the maximum allowed size: %sMB', 'streamtube-core' ),
				'<strong>' . round( wp_max_upload_size() / 1048576 ) . '</strong>'
			),
			'resumable_notice'               => esc_html__( 'Upload failed, attempting to resume...', 'streamtube-core' ),
			'uploading'                      => esc_html__( 'Uploading ...', 'streamtube-core' ),
			'preparing_upload'               => esc_html__( 'Preparing Upload...', 'streamtube-core' ),
			'preparing'                      => esc_html__( 'Preparing...', 'streamtube-core' ),
			'done'                           => esc_html__( 'Done!', 'streamtube-core' ),
			'unlimited'                      => esc_html__( 'Unlimited', 'streamtube-core' ),
			'no_quota'                       => esc_html__( 'No quota', 'streamtube-core' ),
			'copy'                           => esc_html__( 'COPY', 'streamtube-core' ),
			'iframe'                         => esc_html__( 'Iframe', 'streamtube-core' ),
			'shorturl'                       => esc_html__( 'Short URL', 'streamtube-core' ),
			'video_published'                => esc_html__( 'Video Published.', 'streamtube-core' ),
			'saved_changes'                  => esc_html__( 'Saved Changes.', 'streamtube-core' ),
			'post_status_alert'              => esc_html__( 'This {post_type} is {status}.', 'streamtube-core' ),
			'pending_review'                 => esc_html__( 'Pending Review', 'streamtube-core' ),
			'file_encode_done'               => esc_html__( 'has been encoded successfully.', 'streamtube-core' ),
			'view_video'                     => esc_html__( 'view video', 'streamtube-core' ),
			'light_logo'                     => wp_get_attachment_image_url( get_theme_mod( 'custom_logo' ), 'full' ),
			'dark_logo'                      => get_option( 'dark_logo' ),
			'light_mode_text'                => esc_html__( 'Light mode', 'streamtube-core' ),
			'dark_mode_text'                 => esc_html__( 'Dark mode', 'streamtube-core' ),
			'dark_editor_css'                => trailingslashit( STREAMTUBE_CORE_PUBLIC_URL ) . 'assets/css/editor-dark.css?ver=1.3',
			'light_editor_css'               => trailingslashit( STREAMTUBE_CORE_PUBLIC_URL ) . 'assets/css/editor-light.css?ver=1.3',
			'editor_toolbar'                 => array(
				'bold',
				'italic',
				'underline',
				'strikethrough',
				'hr',
				'bullist',
				'numlist',
				'link',
				'unlink',
				'forecolor',
				'undo',
				'redo',
				'removeformat',
				'blockquote'
			),
			'has_woocommerce'                => function_exists( 'WC' ) ? true : false,
			'view_cart'                      => esc_html__( 'view cart', 'streamtube-core' ),
			'added_to_cart'                  => esc_html__( '%s has been added to cart', 'streamtube-core' ),
			'added_to_cart_no_name'          => esc_html__( 'Added to cart', 'streamtube-core' ),
			'public'                         => esc_html__( 'Public', 'streamtube-core' ),
			'publish'                        => esc_html__( 'Publish', 'streamtube-core' ),
			'published'                      => esc_html__( 'Published', 'streamtube-core' ),
			'edit'                           => esc_html__( 'Edit', 'streamtube-core' ),
			'bp_message_sent'                => esc_html__( 'You have sent message successfully.', 'streamtube-core' ),
			'view_ad'                        => esc_html__( 'View Ad', 'streamtube-core' ),
			'cancel'                         => esc_html__( 'Cancel', 'streamtube-core' ),
			'play_now'                       => esc_html__( 'Play now', 'streamtube-core' ),
			'edit'                           => esc_html__( 'Edit', 'streamtube-core' ),
			'save'                           => esc_html__( 'Save', 'streamtube-core' ),
			'report'                         => esc_html__( 'Report', 'streamtube-core' ),
			'comment_reviewed'               => esc_html__( 'This comment is currently being reviewed', 'streamtube-core' ),
			'tax_terms_cache'                => array( 'video_tag', 'post_tag' ),
			'must_cache_terms'               => current_user_can( 'edit_posts' ) ? true : false,
			'upnext_time'                    => 5,
			'sound'                          => array(
				'success' => trailingslashit( STREAMTUBE_CORE_PUBLIC_URL ) . 'assets/media/success.mp3',
				'warning' => trailingslashit( STREAMTUBE_CORE_PUBLIC_URL ) . 'assets/media/warning.mp3'
			),
			'toast'                          => array(
				'delay' => 5000
			),
			'confirm_import_yt'              => esc_html__( 'Do you want to import all checked items?', 'streamtube-core' ),
			'number_posts_imported'          => esc_html__( '%s posts have been imported successfully.', 'streamtube-core' )

		);

		$jsvars = apply_filters( 'streamtube/core/public_scripts/localize', $jsvars );

		wp_localize_script( 'streamtube-core-scripts', 'streamtube', $jsvars );
	}

	/**
	 *
	 * enqueue embed scripts
	 * 
	 * @return [type] [description]
	 */
	public function enqueue_embed_scripts() {

		$this->enqueue_videojs();

		wp_enqueue_style(
			'embed',
			plugin_dir_url( __FILE__ ) . 'assets/css/embed.css',
			array( 'videojs' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/css/embed.css' ),
			'all'
		);

		if ( 0 < $root_size = (int) get_option( 'root_size', '15' ) ) {
			wp_add_inline_style( 'embed', sprintf(
				':root{font-size:%spx}',
				$root_size
			) );
		}

		wp_register_script(
			'jquery.countdown',
			plugin_dir_url( __FILE__ ) . 'assets/js/jquery.countdown.min.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/jquery.countdown.min.js' ),
			true
		);

		wp_register_script(
			'countdown.upcoming',
			plugin_dir_url( __FILE__ ) . 'assets/js/upcoming.js',
			array( 'jquery', 'jquery.countdown' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/upcoming.js' ),
			true
		);

		$jsvars = array(
			'ajaxUrl'  => admin_url( 'admin-ajax.php' ),
			'_wpnonce' => wp_create_nonce( '_wpnonce' )
		);

		$jsvars = apply_filters( 'streamtube/core/player_scripts/localize', $jsvars );

		wp_localize_script( 'player', 'streamtube', $jsvars );

		wp_enqueue_script(
			'embed',
			plugin_dir_url( __FILE__ ) . 'assets/js/embed.js',
			array( 'jquery' ),
			filemtime( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'assets/js/embed.js' ),
			true
		);
	}

	/**
	 *
	 * Load search template
	 *
	 * @since 1.00
	 * 
	 */
	public function load_search_template( $template ) {
		if ( is_search() ) {
			$template = plugin_dir_path( __FILE__ ) . 'page/search.php';
		}

		return $template;
	}

	/**
	 *
	 * Load the Upload section button
	 * 
	 * @since    1.0.0
	 * 
	 */
	public function the_upload_button() {
		if ( is_user_logged_in() ) {

			$args = array(
				'button_icon' => 'icon-upload-cloud'
			);

			/**
			 * @since 2.1.7
			 */
			$args = apply_filters( 'streamtube/core/button/upload/args', $args );

			streamtube_core_load_template( 'misc/btn-upload.php', true, $args );

			do_action( 'btn_upload_loaded' );
		}
	}

	/**
	 *
	 * Load all required modals
	 * 
	 * @since 1.0.0
	 * 
	 */
	public function load_modals() {

		if ( Streamtube_Core_Permission::can_upload() ) {
			streamtube_core_load_template( "modal/upload-video.php", false );
		}

		if ( Streamtube_Core_Permission::can_embed() ) {
			streamtube_core_load_template( "modal/embed-video.php", false );
		}

		if ( ! is_user_logged_in() ) {
			streamtube_core_load_template( "modal/login.php", false );
		}
	}
}
