<?php
/**
 *
 * Comments List table
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $post_type_screen;

if ( ! current_user_can( 'edit_posts' ) ) {
    return streamtube_core_the_notice(
        esc_html__( 'Sorry, you are not allowed to edit comments.', 'streamtube-core' ),
        'danger'
    );    
}

global $wp_locale;

$wp_list_table = new StreamTube_Core_Comments_List_Table( array(
    'screen'    =>  'edit-comments',
    'ajax'      => true
) );

$wp_list_table->enqueue_scripts();

if( ! $post_type_screen ){
    streamtube_core_the_screen_options( $wp_list_table );
}

$pagenum       = $wp_list_table->get_pagenum();

$post_id        = isset( $_REQUEST['post_id'] )     ? absint( $_REQUEST['post_id'] )        : 0;

$comment_id     = isset( $_REQUEST['c'] )           ? absint( $_REQUEST['c'] )              : 0;
$nonce          = isset( $_REQUEST['_wpnonce'] )    ? wp_unslash( $_REQUEST['_wpnonce'] )   : '';
$doaction       = $wp_list_table->current_action();
$_nonce_action  = '';

$comment_status = isset( $_REQUEST['comment_status'] ) ? wp_unslash( $_REQUEST['comment_status'] ) : '';

if( in_array( $doaction , array( 'approvecomment', 'unapprovecomment' ) ) ){
    $_nonce_action = 'approve-comment_' . $comment_id;
}
else{
    $_nonce_action = 'delete-comment_' . $comment_id;
}

if( $comment_id && $nonce && $doaction ){
    if( ! wp_verify_nonce( $nonce, $_nonce_action ) ){
        return streamtube_core_the_notice(
            esc_html__( 'The link you followed has expired.', 'streamtube-core' ),
            'danger'
        );
    }
}

if ( $doaction ) {

    $comment_ids = array();

    if( $comment_id ){
        $comment_ids[] = $comment_id;
    }

    if ( 'delete_all' === $doaction && ! empty( $_REQUEST['pagegen_timestamp'] ) ) {
        /**
         * @global wpdb $wpdb WordPress database abstraction object.
         */
        global $wpdb;

        $comment_status = wp_unslash( $_REQUEST['comment_status'] );
        $delete_time    = wp_unslash( $_REQUEST['pagegen_timestamp'] );
        $comment_ids    = $wpdb->get_col(
            $wpdb->prepare(
                "SELECT comment_ID FROM $wpdb->comments
                WHERE comment_approved = %s AND %s > comment_date_gmt",
                $comment_status,
                $delete_time
            )
        );
        $doaction       = 'delete';
    } elseif ( isset( $_REQUEST['delete_comments'] ) ) {
        $comment_ids = $_REQUEST['delete_comments'];
        $doaction    = $_REQUEST['action'];
    } elseif ( isset( $_REQUEST['ids'] ) ) {
        $comment_ids = array_map( 'absint', explode( ',', $_REQUEST['ids'] ) );
    } elseif ( wp_get_referer() ) {
        wp_safe_redirect( wp_get_referer() );
        exit;
    }

    $approved   = 0;
    $unapproved = 0;
    $spammed    = 0;
    $unspammed  = 0;
    $trashed    = 0;
    $untrashed  = 0;
    $deleted    = 0;

    $redirect_to = remove_query_arg(
        array(
            'trashed',
            'untrashed',
            'deleted',
            'spammed',
            'unspammed',
            'approved',
            'unapproved',
            'ids',
        ),
        wp_get_referer()
    );
    $redirect_to = add_query_arg( 'cpaged', $pagenum, $redirect_to );

    wp_defer_comment_counting( true );

    foreach ( $comment_ids as $comment_id ) { // Check the permissions on each.
        if ( ! current_user_can( 'edit_comment', $comment_id ) ) {
            continue;
        }

        switch ( $doaction ) {
            case 'approve':
            case 'approvecomment':
                wp_set_comment_status( $comment_id, 'approve' );
                ++$approved;
                break;
            case 'unapprove':
            case 'unapprovecomment':
                wp_set_comment_status( $comment_id, 'hold' );
                ++$unapproved;
                break;
            case 'spam':
            case 'spamcomment':
                wp_spam_comment( $comment_id );
                ++$spammed;
                break;
            case 'unspam':
            case 'unspamcomment':
                wp_unspam_comment( $comment_id );
                ++$unspammed;
                break;
            case 'trash':
            case 'trashcomment':
                wp_trash_comment( $comment_id );
                ++$trashed;
                break;
            case 'untrash':
            case 'untrashcomment':
                wp_untrash_comment( $comment_id );
                ++$untrashed;
                break;
            case 'delete':
            case 'deletecomment':
                wp_delete_comment( $comment_id );
                ++$deleted;
                break;
        }
    }

    wp_defer_comment_counting( false );

    if ( $approved ) {
        $redirect_to = add_query_arg( 'approved', $approved, $redirect_to );
    }
    if ( $unapproved ) {
        $redirect_to = add_query_arg( 'unapproved', $unapproved, $redirect_to );
    }
    if ( $spammed ) {
        $redirect_to = add_query_arg( 'spammed', $spammed, $redirect_to );
    }
    if ( $unspammed ) {
        $redirect_to = add_query_arg( 'unspammed', $unspammed, $redirect_to );
    }
    if ( $trashed ) {
        $redirect_to = add_query_arg( 'trashed', $trashed, $redirect_to );
    }
    if ( $untrashed ) {
        $redirect_to = add_query_arg( 'untrashed', $untrashed, $redirect_to );
    }
    if ( $deleted ) {
        $redirect_to = add_query_arg( 'deleted', $deleted, $redirect_to );
    }
    if ( $trashed || $spammed ) {
        $redirect_to = add_query_arg( 'ids', implode( ',', $comment_ids ), $redirect_to );
    }

    wp_safe_redirect( remove_query_arg( 'action', $redirect_to ) );
    exit;
} 
$wp_list_table->prepare_items();

$heading = esc_html__( 'Comments', 'streamtube-core' );

if( $post_id ){
    $heading = sprintf(
        esc_html__( 'Comments on %s %s', 'streamtube-core' ),
        sprintf(
            '<a href="%s">%s</a>',
            esc_url( get_edit_post_link( $post_id ) ),
            get_post( $post_id )->post_title                    
        ),
        sprintf(
            '<a href="%s">> %s</a>',
            esc_url( get_permalink( $post_id ) ),
            esc_html__( 'View posts', 'streamtube-core' )
        )                
    );
}

streamtube_core_the_dashboard_head( $heading );

streamtube_core_the_dashboard_content_start();
?> 
<div class="wp-core-ui">   

    <div class="wrap p-0">

        <hr class="wp-header-end">
  
        <?php $wp_list_table->views(); ?>

        <form id="comments-form" method="get">

            <?php $wp_list_table->search_box( esc_html__( 'Search comments', 'streamtube-core' ), 'search-comment' ); ?>

            <input type="hidden" name="p" value="<?php echo esc_attr( $post_id ); ?>" />

            <input type="hidden" name="comment_status" value="<?php echo esc_attr( $comment_status ); ?>" />
            <input type="hidden" name="pagegen_timestamp" value="<?php echo esc_attr( current_time( 'mysql', 1 ) ); ?>" />

            <input type="hidden" name="_total" value="<?php echo esc_attr( $wp_list_table->get_pagination_arg( 'total_items' ) ); ?>" />
            <input type="hidden" name="_per_page" value="<?php echo esc_attr( $wp_list_table->get_pagination_arg( 'per_page' ) ); ?>" />
            <input type="hidden" name="cpaged" value="<?php echo esc_attr( $wp_list_table->get_pagination_arg( 'page' ) ); ?>" />

            <?php if ( isset( $_REQUEST['cpaged'] ) ) { ?>
                <input type="hidden" name="cpaged" value="<?php echo esc_attr( absint( $_REQUEST['cpaged'] ) ); ?>" />
            <?php } ?>

            <?php $wp_list_table->display(); ?>

        </form>
        <div id="ajax-response"></div>

        <?php
        $wp_list_table->quickedit();
        wp_comment_trashnotice();
        ?>

    </div>

</div>
<?php streamtube_core_the_dashboard_content_end();