<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

// Check if current user can publish posts
$can_upload = Streamtube_Core_Permission::can_upload();

/**
 *
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/form/upload_video/before' );
?>

<div id="drag-drop-upload" class="drag-drop-upload upload-form__group">

	<?php
	/**
	 *
	 * @since  1.0.0
	 * 
	 */
	do_action( 'streamtube/core/form/upload_video/container/before' );
	?>

	<?php echo $can_upload ? '<label class="upload-form__label">' : '<div class="upload-form__label">'; ?>

		<input multiple name="video_file" type="file" accept="video/*" class="d-none video_file">

		<div class="top-50 start-50 translate-middle position-absolute text-center w-75">
			<span class="icon icon-upload"></span>
			<h5>
				<?php echo $args['upload_text'] ?>
			</h5>
			<?php
			/**
			 *
			 * @since  1.0.0
			 * 
			 */
			do_action( 'streamtube/core/form/upload_video/inside/before' );
			?>
			<?php 
			if( $args['max_size_text'] ){
				printf(
					'<p class="text-muted small mb-1">%s</p>',
					$args['max_size_text']
				);
			}
			?>
			<?php
			if( isset( $args['max_file_text'] ) ){
				printf(
					'<p class="text-muted small mb-1">%s</p>',
					$args['max_file_text']
				);
			}
			?>			
			<?php
			if( isset( $args['allowed_formats_text'] ) ){
				printf(
					'<p class="text-muted small mb-3">%s</p>',
					$args['allowed_formats_text']
				);
			}
			?>

			<?php
			if( current_user_can( get_post_type_object( 'video' )->cap->publish_posts ) ){
				streamtube_core_the_field_control( array(
					'label'			=>	esc_html__( 'Status', 'streamtube-core' ),
					'name'			=>	'post_status',
					'id'			=>	'upload-post_status',
					'type'			=>	'select',
					'current'		=>	get_option( 'auto_publish' ) ? 'publish' : 'pending',
					'options'		=>	array(
						'publish'	=>	esc_html__( 'Publish', 'streamtube-core' ),
						'pending'	=>	esc_html__( 'Pending review', 'streamtube-core' )
					)
				) );
			}
			?>

			<?php
			/**
			 *
			 * @since  1.0.0
			 * 
			 */
			do_action( 'streamtube/core/form/upload_video/inside/after' );
			?>				
		</div>
	<?php echo $can_upload ? '</label>' : '</div>'; ?>

	<?php
	/**
	 *
	 * @since  1.0.0
	 * 
	 */
	do_action( 'streamtube/core/form/upload_video/container/after' );
	?>
</div>

<?php 
/**
 *
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/form/upload_video/after' );