<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post, $post_type_screen;

$object = $args['args'];
$tax    = $object->name;

printf(
	'<div class="widget widget-taxonomy widget-%1$s tax-%1$s">',
	esc_attr( $tax )
);

/**
 * Fires before content
 *
 * @since 2.0
 */
do_action( 'streamtube/core/post/edit/tax/before', $object, $tax );

/**
 * @since 2.0
 */
do_action( "streamtube/core/post/edit/{$tax}/before", $object );
?>

<?php if ( is_callable( $object->meta_box_cb ) && $object->meta_box_cb !== 'post_categories_meta_box' ) : ?>

	<?php call_user_func( $object->meta_box_cb, $post, $args ); ?>

<?php else : ?>

	<?php if ( current_user_can( $object->cap->edit_terms ) ) : ?>

		<?php

		add_filter( 'wp_terms_checklist_args', 'streamtube_core_filter_wp_terms_checklist' );

		$meta_box_args = array(
			'id'    => sprintf( '%s-metabox', $tax ),
			'title' => $object->labels->name,
			'args'  => array(
				'taxonomy' => $tax
			)
		);

		/**
		 *
		 * Filter the meta box args
		 * 
		 * @param array $meta_box_args
		 * @param object $taxonomy_object
		 * 
		 */
		$meta_box_args = apply_filters( "streamtube/core/post/edit/{$tax}/meta_box_args", $meta_box_args, $object );

		post_categories_meta_box( $post, $meta_box_args );

		remove_filter( 'wp_terms_checklist_args', 'streamtube_core_filter_wp_terms_checklist' );

		?>

	<?php else : ?>

		<?php

		$checklist_args = array(
			'taxonomy'      => $tax,
			'checked_ontop' => false,
			'echo'          => false
		);

		/**
		 *
		 * Filter the checklist args
		 * 
		 * @param string $tax
		 * @param object taxonomy $object
		 * 
		 * @since 1.3
		 * 
		 */
		$checklist_args = apply_filters( 'streamtube/core/post/edit/tax/checklist_args', $checklist_args, $object, $tax );

		$checklist = wp_terms_checklist( $post ? $post->ID : 0, $checklist_args );

		if ( ! empty( $checklist ) ) :

			$max_items = (int) get_option( sprintf( 'taxonomy_%s_%s_max_items', $post_type_screen, $tax ), 0 );
			if ( Streamtube_Core_Permission::moderate_posts( 0, $post_type_screen ) ) {
				$max_items = 0;
			}
			/**
			 *
			 * Filter max items can be checked of the taxonomy
			 * 
			 * @param int $max_items
			 * @param object taxonomy $object
			 * @param string $tax
			 *
			 * @since 2.0
			 * 
			 */
			$max_items = apply_filters( 'streamtube/core/post/edit/tax/max_items', $max_items, $object, $tax );

			?>
			<ul class="categorychecklist" data-max-items="<?php echo esc_attr( $max_items ); ?>">
				<?php echo $checklist; ?>
			</ul>

		<?php endif; ?>

	<?php endif; ?>

<?php endif; ?>

<?php
/**
 * Fires after content
 *
 * @since 2.0
 */
do_action( 'streamtube/core/post/edit/tax/after', $object, $tax );

/**
 * @since 2.0
 */
do_action( "streamtube/core/post/edit/{$tax}/after", $object );
?>
</div>