<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post, $post_type_screen;

$object = $args['args'];
$tax    = $object->name;

$meta_box_cb = is_callable( $object->meta_box_cb ) && $object->meta_box_cb !== 'post_tags_meta_box' ? true : false;

printf(
	'<div class="widget widget-taxonomy widget-%1$s tax-%1$s">',
	esc_attr( $tax )
);

/**
 * Fires before tax
 *
 * @since 2.0
 */
do_action( 'streamtube/core/post/edit/tax/before', $object, $tax );

/**
 * @since 2.0
 */
do_action( "streamtube/core/post/edit/{$tax}/before", $object );

if ( $meta_box_cb ) :
	call_user_func( $object->meta_box_cb, $post, $args );
else :

	$max_items = (int) get_option( sprintf( 'taxonomy_%s_%s_max_items', $post_type_screen, $tax ), 0 );
	if ( Streamtube_Core_Permission::moderate_posts( 0, $post_type_screen ) ) {
		$max_items = 0;
	}
	$free_input   = wp_validate_boolean( get_option( sprintf( 'taxonomy_%s_%s_freeinput', $post_type_screen, $tax ), 'on' ) );
	$auto_suggest = wp_validate_boolean( get_option( sprintf( 'taxonomy_%s_%s_autosuggest', $post_type_screen, $tax ) ) );
	$max_chars    = 100;
	/**
	 *
	 * Filter the tax options
	 * 
	 */
	$tax_options = apply_filters( "streamtube/core/post/edit/tax/options", compact(
		'max_items',
		'free_input',
		'auto_suggest',
		'max_chars'
	), $object, $tax );

	extract( $tax_options );

	$title = sprintf(
		esc_html__( '%s (separated by commas)', 'streamtube-core' ),
		$tax == 'video_tag' ? esc_html__( 'Tags', 'streamtube-core' ) : $object->label
	);

	/**
	 *
	 * Filter max items can be checked of the taxonomy
	 * 
	 * @param int $max_items
	 * @param object taxonomy $object
	 * @param string $tax
	 *
	 * @since 2.0
	 * 
	 */
	$max_items = apply_filters( 'streamtube/core/post/edit/tax/max_items', $max_items, $object, $tax );

	if ( $max_items > 0 ) {
		$title = sprintf(
			esc_html__( '%s (separated by commas, maximum of %s tags)', 'streamtube-core' ),
			$tax == 'video_tag' ? esc_html__( 'Tags', 'streamtube-core' ) : $object->label,
			$max_items
		);
	}

	/**
	 *
	 * Filter the widget title
	 * 
	 * @since 1.3
	 */
	$title = apply_filters( 'streamtube/core/post/edit/tax/title', $title, $object, $tax );

	$tag_items = is_object( $post ) ? wp_get_post_terms( $post->ID, $tax ) : array();

	$tag_input_attrs = array(
		'data-role'         => 'tags-input',
		'data-max-tags'     => $max_items,
		'data-max-chars'    => $max_chars,
		'data-tax'          => $tax,
		'data-free-input'   => $free_input,
		'data-auto-suggest' => $auto_suggest
	);

	/**
	 *
	 * Filter tag_input_attrs can be checked of the taxonomy
	 * 
	 * @param int $max_items
	 * @param object taxonomy $object
	 * @param string $tax
	 *
	 * @since 2.0
	 * 
	 */
	$tag_input_attrs = apply_filters( 'streamtube/core/post/edit/tax/tag_input_attrs', $tag_input_attrs, $object, $tax );

	streamtube_core_the_field_control( array(
		'label'      => $title,
		'name'       => sprintf( 'tax_input[%s]', $tax ),
		'value'      => is_array( $tag_items ) ? join( ',', wp_list_pluck( $tag_items, 'name' ) ) : '',
		'data'       => $tag_input_attrs,
		'wrap_class' => 'taginput-wrap'
	) );

endif;

/**
 * Fires after content
 *
 * @since 2.0
 */
do_action( 'streamtube/core/post/edit/tax/after', $object, $tax );

/**
 * @since 2.0
 */
do_action( "streamtube/core/post/edit/{$tax}/after", $object );
?>
</div>