<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

wp_enqueue_editor();
wp_enqueue_script( 'bootstrap-tagsinput' );
wp_enqueue_style( 'bootstrap-tagsinput' );

?>
<div class="modal fade" id="modal-upload" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modal-upload-label" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
		<div class="modal-content step-wrap bg-white">
			
			<div class="modal-header bg-light">
				<h5 class="modal-title" id="modal-upload-label">
					<?php esc_html_e( 'Upload Videos', 'streamtube-core' ); ?>
				</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php esc_attr_e( 'Close', 'streamtube-core' ); ?>"></button>
			</div>

			<div class="modal-body">
				<form id="form-submit-video" class="form-ajax form-steps upload-video-form" autocomplete="off">
					<?php streamtube_core_the_upload_form(); ?>
					
					<?php printf(
						'<input type="hidden" name="action" value="%s">',
						esc_attr( streamtube_core_get_upload_form_action() )
					);?>

					<?php printf(
						'<input type="hidden" name="request_url" value="%s">',
						esc_attr( admin_url( 'admin-ajax.php' ) )
					);?>					

					<?php printf(
						'<input type="hidden" name="nonce" value="%s">',
						esc_attr( wp_create_nonce( 'do-' . streamtube_core_get_upload_form_action() ) )
					);?>

					<input type="hidden" name="quick_update" value="1">
				</form>
			</div>
		</div>
	</div>
</div>