<?php get_header( 'dashboard' );?>
	    <div id="dashboard-<?php echo get_queried_object_id();?>" class="user-dashboard overflow-hidden bg-white p-0">

            <div class="col_sidebar sidebar-secondary navbar-dark p-0">
                <?php 

                /**
                 *
                 * Fires before sidebar
                 * 
                 */
                do_action( 'streamtube/core/user/dashboard/sidebar/before' );

                /**
                 *
                 * The sidebar
                 * 
                 */
                do_action( 'streamtube/core/user/dashboard/sidebar' );

                /**
                 *
                 * Fires after sidebar
                 * 
                 */
                do_action( 'streamtube/core/user/dashboard/sidebar/after' );

                ?>
            </div>

			<div class="col_main w-100">

				<div class="p-4">
					<?php

					global $post, $add_new_post_screen, $post_type_screen;

					if( $post && ! $add_new_post_screen ){

						if( Streamtube_Core_Permission::can_edit_post( $post->ID ) ){

							$post_type = $post->post_type;

							streamtube_core_the_dashboard_head( $post->post_title );

							$base_url = streamtube_core_get_user_dashboard_url( get_queried_object_id(), $post_type );

							if( ! get_option( 'permalink_structure' ) ){
								$base_url = add_query_arg(
									array(
										'post_id'	=>	$post->ID
									),
									$base_url
								);
							}
							else{
								$base_url = trailingslashit( $base_url ) . $post->ID;
							}

							streamtube_core_the_dashboard_content_start();						
								streamtube_core()->get()->post->the_edit_post_menu( array(
									'user_id'		=>	get_queried_object_id(),
									'base_url'      =>  $base_url,
									'post'			=>	$post
								) );

								streamtube_core()->get()->post->the_edit_post_main();
							streamtube_core_the_dashboard_content_end();
						
						}else{
							streamtube_core_the_notice(
								esc_html__( 'Sorry, you are not allowed to edit this post.', 'streamtube-core' ),
								'danger'
							);
						}
					}
					else{
						streamtube_core_load_template( 'post/edit/edit.php', true );
					}
					?>

				</div>

			</div><!--.col-10-->
		</div>

        <?php
        /**
         *
         * Fires after footer
         * 
         */
        do_action( 'streamtube/footer/after' );
        ?>		
        <?php wp_footer();?>

    </body>

</html>