<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

wp_enqueue_script( 'bootstrap-tagsinput' );
wp_enqueue_style( 'bootstrap-tagsinput' );

global $post, $add_new_post_screen, $post_type_screen;

$http_data = wp_parse_args( $_REQUEST, array(
	'view'  => '',
	'nonce' => ''
) );

if ( $http_data['view'] === 'add-post' && ! wp_verify_nonce( $http_data['nonce'], 'add-new-' . $post_type_screen ) ) {
	streamtube_core_the_notice(
		esc_html__( 'Invalid nonce, please try again.', 'streamtube-core' ),
		'warning'
	);

	return;
}

if ( ! StreamTube_Core_Permission::can_create_posts( $post_type_screen ) ) {
	streamtube_core_the_notice(
		sprintf(
			esc_html__( 'Sorry, You do not have permission to create new %s.', 'streamtube-core' ),
			get_post_type_object( $post_type_screen )->labels->name
		),
		'danger'
	);

	return;
}

if ( $add_new_post_screen ) {

	if ( ! function_exists( 'get_default_post_to_edit' ) ) {
		include ABSPATH . 'wp-admin/includes/post.php';
	}

	$post = get_default_post_to_edit( $post_type_screen, true );
}

/**
 *
 * Fires before edit post screen
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/post/edit_wrapper/before', $post, $post_type_screen );
?>

<form class="form-ajax form-add-post" method="post" autocomplete="off">

	<?php
	/**
	 *
	 * Fires before edit post screen
	 * @since  1.0.0
	 * 
	 */
	do_action( 'streamtube/core/post/edit_form/before' );
	?>

	<div class="widget mb-0">
		<div class="widget-title-wrap d-flex bg-white sticky-top border p-3">

			<div class="d-none d-sm-block group-title flex-grow-1">
				<h3 class="page-title text-body">
					<?php

					if ( $post->post_status === 'auto-draft' ) {
						printf(
							esc_html__( 'Add new %s', 'streamtube-core' ),
							get_post_type_object( $post_type_screen )->labels->singular_name
						);
					} else {
						printf(
							esc_html__( 'Update %s', 'streamtube-core' ),
							get_post_type_object( $post_type_screen )->labels->singular_name
						);
					} ?>
				</h3>
			</div>

			<div class="ms-md-auto">
				<div class="d-flex flex-wrap gap-3">

					<?php if ( $post ) : ?>

						<button type="button" class="btn btn-danger px-3" name="submit" value="delete"
							data-bs-toggle="modal" data-bs-target="#deletePostModal"
							data-post-id="<?php echo $post->ID; ?>">
							<span class="btn__icon icon-trash"></span>
							<span class="btn__text">
								<?php esc_html_e( 'Trash', 'streamtube-core' ); ?>
							</span>
						</button>

						<a class="btn btn-info text-white current-post-permalink px-3"
							href="<?php the_permalink( $post->ID ); ?>">
							<span class="btn__icon icon-eye"></span>
							<span class="btn__text">
								<?php esc_html_e( 'View', 'streamtube-core' ); ?>
							</span>
						</a>

					<?php endif; ?>

					<button type="submit" class="btn btn-primary px-3" name="submit" value="update">
						<span class="btn__icon icon-pencil"></span>
						<span class="btn__text">
							<?php

							$btn_text = esc_html__( 'Publish', 'streamtube-core' );

							if ( $post ) {
								$btn_text = esc_html__( 'Update', 'streamtube-core' );
							}

							echo apply_filters( 'streamtube/core/post/edit/submit/text', $btn_text, $post );
							?>
						</span>
					</button>
				</div>
			</div>
		</div>
		<div class="widget-content">

			<?php
			/**
			 *
			 * Fires before edit post screen
			 * @since  1.0.0
			 * 
			 */
			do_action( 'streamtube/core/post/edit/before', $post, $post_type_screen );
			?>

			<div class="row">
				<div class="col-12 col-lg-8 col-xl-8 col-xxl-9">
					<div id="postbox-container-1" class="postbox-container w-100">
						<?php streamtube_core_load_template( 'post/edit/main.php', false ); ?>
					</div>
				</div>
				<div class="col-12 col-lg-4 col-xl-4 col-xxl-3">
					<div id="postbox-container-2" class="postbox-container w-100">
						<?php streamtube_core_load_template( 'post/edit/metaboxes.php' ); ?>
					</div>
				</div><!--.col-3-->
			</div>
			<?php
			/**
			 *
			 * Fires after edit post screen
			 * @since  1.0.0
			 * 
			 */
			do_action( 'streamtube/core/post/edit/after', $post, $post_type_screen );
			?>

		</div>
	</div>

	<?php printf(
		'<input type="hidden" name="action" value="%s">',
		$post ? 'update_post' : 'add_post'
	); ?>

	<?php
	if ( $post->post_status === 'auto-draft' ) {
		printf(
			'<input type="hidden" name="_auto_draft" value="%s">',
			esc_attr( $post->post_status )
		);
	} ?>

	<?php
	wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false );
	wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false );
	?>

	<div class="columns-prefs d-none">
		<input type="checkbox" value="2" checked />
	</div>

	<?php
	/**
	 *
	 * Fires before edit post screen
	 * @since  1.0.0
	 * 
	 */
	do_action( 'streamtube/core/post/edit_form/after', $post, $post_type_screen );
	?>

</form>

<?php
/**
 *
 * Fires before edit post screen
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/post/edit_wrapper/after', $post, $post_type_screen );
?>

<?php streamtube_core_load_template( 'modal/delete-post.php' ); ?>