<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

global $post, $post_type_screen, $streamtube;

/**
 *
 * Fires before title
 *
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/post/edit/title/before', $post );

echo streamtube_get_the_post_status_alert( $post );

if( post_type_supports( $post_type_screen, 'title' ) ){
    streamtube_core_the_field_control( array(
        'label'         =>  esc_html__( 'Title', 'streamtube-core' ),
        'type'          =>  'text',
        'name'          =>  'post_title',
        'value'         =>  $post ? $post->post_title : ''
    ) );

    if( post_type_supports( $post_type_screen, 'slug' ) ){
        $editable_slug = apply_filters( 'editable_slug', $post->post_name, $post );
        streamtube_core_the_field_control( array(
            'label'         =>  esc_html__( 'Slug', 'streamtube-core' ),
            'type'          =>  'text',
            'name'          =>  'post_name',
            'value'         =>  $post ? $editable_slug : ''
        ) );  
    }
}

/**
* @since  1.0.0
* 
*/
do_action( 'streamtube/core/post/edit/metaboxes/advanced', $post );

/**
 *
 * Fires before content
 *
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/post/edit/content/before', $post );

if( post_type_supports( $post_type_screen, 'editor' ) ){
    $editor_setings = array(
        'teeny'             =>  false,
        'media_buttons'     =>  false,
        'drag_drop_upload'  =>  false
    );

    if( get_option( 'editor_add_media' ) ){
        $editor_setings = array_merge( $editor_setings, array(
            'media_buttons'     =>  current_user_can( 'upload_files' ) ? true : false,
            'drag_drop_upload'  =>  current_user_can( 'upload_files' ) ? true : false
        ) );
    }

    if( apply_filters( 'streamtube/core/wpeditor/teeny', false ) === true ){
        $editor_setings = array_merge( $editor_setings, array(
            'teeny'             =>  true,
            'media_buttons'     =>  false,
            'drag_drop_upload'  =>  false,
            'tinymce'       => array(
                'toolbar1'      => 'bold,italic,underline,bullist,numlist,link,unlink,forecolor,undo,redo,image'
            ),
            'quicktags'     =>  array(
                'buttons'   => 'strong,em,underline,ul,ol,li,code,img'
            )
        ) );
    }

    streamtube_core_the_field_control( array(
        'label'     =>  esc_html__( 'Content', 'streamtube-core' ),
        'type'      =>  'editor',
        'name'      =>  'post_content',
        'settings'  =>  ! current_user_can( 'administrator' ) ? $editor_setings : array(),
        'value'     =>  $post ? $post->post_content : ''
    ) );    
}

/**
 *
 * Fires after content field.
 *
 * @since  1.0.0
 * 
 */
do_action( 'streamtube/core/post/edit/content/after', $post );


/**
* @since  1.0.0
* 
*/
do_action( 'streamtube/core/post/edit/metaboxes/normal', $post );

if( is_object( $post ) ){
    printf(
        '<input type="hidden" name="post_ID" value="%s">',
        $post->ID
    );

    printf(
        '<input type="hidden" name="edit-post-security" value="%s">',
        esc_attr( wp_create_nonce( 'edit-post-' . $post->ID ) )
    );    
}