<?php
/**
 * Capabilities Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! current_user_can( 'promote_users' ) ) {
	streamtube_core_the_notice(
		esc_html__( 'You do not have permission to access this page.', 'streamtube-core' ),
		'danger'
	);
	return;
}

global $wp_roles;

$role = isset( $_REQUEST['role'] ) ? wp_unslash( $_REQUEST['role'] ) : '';

wp_enqueue_script( 'streamtube-core-permission' );

streamtube_core_the_dashboard_head( esc_html__( 'Content Capabilities', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

?>
<form method="get">

	<?php streamtube_core_the_modules_dropdown(); ?>

	<?php streamtube_core_the_roles_dropdown(); ?>

	<button type="submit" class="btn btn-primary btn-sm">
		<span class="btn__icon icon-search"></span>
		<span class="btn__text"><?php esc_html_e( 'Search', 'streamtube-core' ); ?></span>
	</button>

	<input type="hidden" name="has_spinner" value="on">

</form>

<div class="my-4">
	<?php if ( is_string( $role ) && $role ) {
		if ( $role === 'all' ) {

			?>
			<ul class="nav nav-tabs" id="roles-tab" role="tablist"><?php
			foreach ( get_editable_roles() as $role_id => $value ) {

				?>
					<li class="nav-item">
						<?php printf(
							'<a class="text-body nav-link %1$s" id="%2$s-tab" data-bs-toggle="tab" data-bs-target="#%2$s-tab-pane" type="button" role="tab" aria-controls="%2$s-tab-pane" aria-selected="true">%3$s</a>',
							array_keys( get_editable_roles() )[0] === $role_id ? 'active' : '',
							esc_attr( $role_id ),
							translate_user_role( $wp_roles->roles[ $role_id ]['name'] )
						); ?>
					</li>
					<?php
			}

			?>
			</ul>

			<div class="tab-content" id="roles-tab-content">
				<?php foreach ( get_editable_roles() as $role_id => $value ) : ?>

					<?php printf(
						'<div class="tab-pane fade %s" id="%2$s-tab-pane" role="tabpanel" aria-labelledby="%2$s-tab" tabindex="0">',
						array_keys( get_editable_roles() )[0] === $role_id ? 'show active' : '',
						esc_attr( $role_id ),
					); ?>

					<?php printf(
						'<h3 class="my-4">%s</h3>',
						translate_user_role( $wp_roles->roles[ $role_id ]['name'] )
					); ?>
					<?php streamtube_core_the_module_capability_checkboxes_list( '', $role_id ); ?>
				</div>

			<?php endforeach; ?>
		</div>
		<?php
		} elseif ( get_role( $role ) ) {
			streamtube_core_the_module_capability_checkboxes_list();
		}
	} else {
		streamtube_core_the_notice(
			esc_html__( 'Please select content and role.', 'streamtube-core' ),
			'info'
		);
	} ?>
</div>
<?php

streamtube_core_the_dashboard_content_end();