<?php
/**
 * Storage Capability setting Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

wp_enqueue_script( 'streamtube-core-permission' );

streamtube_core_the_notice(
    esc_html__( 'Assigning these capabilities will increase the user\'s quota, however, unassigning them will not affect the user\'s quota.', 'streamtube-core' ),
    'info'
);

?>

<form class="form-ajax">

    <?php
    streamtube_core_the_field_control( array(
        'type'  =>  'text',
        'label' =>  esc_html__( 'Storage Capacity (MB)', 'streamtube-core' ),
        'name'  =>  'capacity'
    ) );
    ?>

    <?php wp_nonce_field( 'add_quota_capability' );?>

    <input type="hidden" name="action" value="streamtube/core/storage/add_quota_capacity">

    <p>
        <button type="submit" class="btn btn-primary btn-sm px-3">
            <span class="btn__icon icon-pencil"></span>
            <span class="btn__text">
                <?php esc_html_e( 'Add', 'streamtube-core' );?>
            </span>
        </button>
    </p>    

    <ul class="list-caps-checkboxes list-group list-group-numbered bg-white border">
        <?php echo streamtube_core_get_storage_capacity_list(); ?>
    </ul>

</form>