<?php
/**
 * Terms List Table Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

global $post_type, $taxonomy;

$errors         = false;

$tag = $tax = null;

$can_edit_terms = current_user_can( get_taxonomy( $taxonomy )->cap->edit_terms );
$tag_ID         = isset( $_REQUEST['tag_ID'] ) ? absint( $_REQUEST['tag_ID'] ) : 0;

$wp_list_table = new StreamTube_Core_Terms_List_Table( array(
    'screen'    =>  convert_to_screen( 'edit-' . $taxonomy ),
    'post_type' =>  $post_type
) );

$wp_list_table->enqueue_scripts();

streamtube_core_the_screen_options( $wp_list_table );

$referer  = wp_get_referer();
if ( ! $referer ) { // For POST requests.
    $referer = wp_unslash( $_SERVER['REQUEST_URI'] );
}
$referer = remove_query_arg( array( '_wp_http_referer', '_wpnonce', 'error', 'message', 'paged' ), $referer );

$action = $wp_list_table->current_action();
?>

<?php streamtube_core_the_dashboard_head( get_taxonomy( $taxonomy )->labels->name ); ?>

<?php streamtube_core_the_dashboard_content_start(); ?>
    <div class="wp-core-ui">
        <div id="wpbody-content">
            <?php 
            if( $tag_ID && term_exists( $tag_ID, $taxonomy ) ) : 

                if( $action ) :
                    switch ( $action ) {
                        case 'editedtag':
                            check_admin_referer( 'update-tag_' . $tag_ID );

                            if ( ! current_user_can( 'edit_term', $tag_ID ) ) {
                                streamtube_core_the_notice(
                                    esc_html__( 'Sorry, you are not allowed to edit this item.', 'streamtube-core' ),
                                    'danger'
                                );                   
                            }else{

                                $ret = wp_update_term( $tag_ID, $taxonomy, array_merge( $_POST, array(
                                    'name'  =>  wp_unslash( $_POST['tag-name'] )
                                ) ) );

                                if( is_wp_error( $ret ) ){
                                    streamtube_core_the_notice(
                                       $ret,
                                       'danger'
                                    );
                                }else{
                                    streamtube_core_the_notice(
                                        esc_html__( 'Item updated.', 'streamtube-core' ),
                                        'success'
                                    );                            
                                }
                            }
                        break;

                        case 'delete':
                            check_admin_referer( 'delete-tag_' . $tag_ID );

                            if ( ! current_user_can( 'delete_term', $tag_ID ) ) {
                                streamtube_core_the_notice(
                                   esc_html__( 'Sorry, you are not allowed to delete this item.', 'streamtube-core' ),
                                   'danger'
                                );                        
                            }else{
                                wp_delete_term( $tag_ID, $taxonomy );

                                wp_redirect( $referer );
                                exit;
                            }
                        break;
                    }
                endif;

                $tag = get_term( $tag_ID, $taxonomy, OBJECT, 'edit' );

                if( $tag ):
                    $tax = get_taxonomy( $tag->taxonomy );

                    ob_start();
                    include_once ABSPATH . 'wp-admin/edit-tag-form.php';
                    $output = str_replace( 'edit-tags.php', '', ob_get_clean() );
                    $output = str_replace( 'name="name"', 'name="tag-name"', $output );
                    $output = preg_replace( '/<span id="delete-link">.*?<\/span>/s' , '', $output);

                    echo $output;

                endif;

            else:

                switch ( $action ) {
                    case 'bulk-delete':
                        check_admin_referer( 'bulk-tags' );

                        if ( ! current_user_can( $wp_list_table->get_taxonomy_object()->cap->delete_terms ) ) {
                            streamtube_core_the_notice(
                                esc_html__( 'Sorry, you are not allowed to delete these items.', 'streamtube-core' ),
                                'danger'
                            );
                        }else{

                            $tags = (array) $_REQUEST['delete_tags'];
                            foreach ( $tags as $tag_ID ) {
                                wp_delete_term( $tag_ID, $taxonomy );
                            }

                            streamtube_core_the_notice(
                                esc_html__( 'Items deleted.', 'streamtube-core' ),
                                'success'
                            );
                        }

                    break;
                }

                $wp_list_table->prepare_items();
                ?>            
                
                <div class="row">

                    <?php printf(
                        '<div class="col-12 col-sm-12 col-md-12 col-lg-%1$s col-xl-%1$s">',
                        $can_edit_terms ? 4 : 12
                    )?>

                        <?php include_once STREAMTUBE_CORE_PUBLIC . '/form/add-term-form.php';?>

                    </div>

                    <?php printf(
                        '<div class="col-12 col-sm-12 col-md-12 col-lg-%1$s col-xl-%1$s">',
                        $can_edit_terms ? 8 : 12
                    )?>
                        <form id="posts-filter" method="post">
                            <?php 
                            $wp_list_table->search_box( 
                                get_taxonomy( $taxonomy )->labels->search_items,
                                $taxonomy
                            ); 
                            ?>                            
                            <?php $wp_list_table->display(); ?>
                        </form>

                        <?php if( ! isset( $_REQUEST['tag_ID'] ) ){
                            $wp_list_table->output_inline_edit();
                        }?>
                    </div>
                </div>

            <?php endif;?>

        </div>
    </div>
<?php streamtube_core_the_dashboard_content_end();