<?php
/**
 *
 * Edit User Capabilities template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $wp;

$user_id    = isset( $_REQUEST['user_id'] ) ? absint( $_REQUEST['user_id'] ) : 0;

$userdata   = get_userdata( $user_id );

// Always check capability
if ( ! current_user_can( 'promote_users' ) || ! $userdata ) {
    return streamtube_core_the_notice(
        esc_html__( 'You do not have permission to promote this user.', 'streamtube-core' ),
        'danger'
    );    
}

wp_enqueue_script( 'streamtube-core-permission' );

streamtube_core_the_notice(
    sprintf(
        __( 'You are editing <strong>ID: #%s %s</strong> capabilities.', 'streamtube-core' ),
        $user_id,
        $userdata->user_login
    ),
    'info'
); 

streamtube_core_the_notice(
    esc_html__( 'Caution: Avoid assigning high-level capabilities to regular users.', 'streamtube-core' ),
    'warning'
); 

streamtube_core_the_field_control( array(
    'type'          =>  'search',
    'label'         =>  esc_html__( 'Search capabilities', 'streamtube-core' ),
    'name'          =>  'search-capabilities',
    'field_class'   =>  'search-list-item form-control input-field w-100'
) );

streamtube_the_showhide_nav_tabs();

$capabilities   = array();

foreach ( get_editable_roles() as $role_id => $value ) {
    $capabilities = array_merge( $capabilities, array_keys( $value['capabilities'] ) );
}

$capabilities = array_unique( array_filter( array_values( $capabilities ) ) );

?>
<form class="form-ajax">
    <ul class="list-caps-checkboxes list-group list-group-numbered m-0 p-0 border checkboxes-rendered">
    <?php

    for ( $i = 0;  $i < count( $capabilities );  $i++) {

        if( ! isset( $capabilities[$i] ) || empty( $capabilities[$i] ) ){
            continue;
        }

        $has_cap = isset( $userdata->caps[ $capabilities[$i] ] ) && $userdata->caps[ $capabilities[$i] ];

        printf(
            '<li class="bg-white border-bottom list-group-item capability-item capability-%1$s" data-capability=="%1$s">',
            esc_attr( $capabilities[$i] )
        );
        ?>

            <div class="mb-3 form-check">
                
                <?php printf(
                    '<input class="add-capability form-check-input float-none" type="checkbox" name="capabilities[]" value="%1$s" id="capability-%1$s" %2$s data-granted="%2$s"/>',
                    esc_attr( $capabilities[$i] ),
                    $has_cap ? 'checked' : ''
                );?>

                <?php
                    printf( 
                        '<label class="form-check-label ms-2 %1$s" for="capability-%2$s">%2$s</label>', 
                        $has_cap ? 'text-success fw-bold' : 'text-muted',
                        esc_attr( $capabilities[$i] )
                    );
                ?>                

            </div>
        </li>
        <?php
    }

    ?>
    </ul>

    <?php printf(
        '<input type="hidden" name="action" value="%s" />',
        'streamtube/update_user_capabilities'
    ); ?>

    <?php printf(
        '<input type="hidden" name="user_id" value="%s" />',
        esc_attr( $user_id )
    ); ?>    

    <?php printf(
        '<input type="hidden" name="_wpnonce" value="%s" />',
        esc_attr( wp_create_nonce( 'update_user_capabilities_' . $user_id ) )
    ); ?> 

    <?php printf(
        '<input type="hidden" name="redirect_uri" value="%s" />',
        esc_url( home_url( $wp->request ) )
    ); ?>        

    <div class="d-flex gap-3 mt-4">
    
        <button type="submit" class="btn btn-danger px-4">
            <span class="btn__icon icon-pencil me-2"></span>
            <span class="btn__text"><?php esc_html_e( 'Update', 'streamtube-core' );?></span>
        </button>

        <?php printf(
            '<a class="text-body" href="%s">%s</a>',
            esc_url( home_url( $wp->request ) ),
            esc_html__( 'Back', 'streamtube-core' )
        )?>

    </div>
</form>