<?php
/**
 *
 * BuddyPress component template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $bp_component_object, $streamtube;

$component_id = $bp_component_object->component_id;

if( $component_id == 'xprofile' ){
    $component_id = 'profile';
}                    

if( is_callable( $bp_component_object->screen_function ) ){

    call_user_func( $bp_component_object->screen_function );

    printf(
        '<div id="buddypress" class="buddypress-wrap buddypress-component component-%s bp-dir-hori-nav alignwide">',
        esc_attr( $component_id )
    );

        streamtube_core_the_dashboard_head( $bp_component_object->name );

        streamtube_core_the_dashboard_content_start();
        ?>

        <div class="bp-wrap">

            <?php 
            if( in_array( $component_id , $streamtube->get()->buddypress->get_all_components() ) ):

                bp_get_template_part( 'members/single/' . $component_id );

            else:
                do_action( 'bp_template_content' );
            endif;
            ?>

            <div class="clearfix"></div>
            
        </div>
        <?php streamtube_core_the_dashboard_content_end(); ?>
    </div>
    <?php

}else{
    echo '<div class="alert alert-warning">';
    if( current_user_can( 'administrator' ) ){
        printf(
            esc_html__( '%s callback was not found.', 'streamtube-core' ),
            is_string( $bp_component_object->screen_function ) ? $bp_component_object->screen_function : json_encode( $bp_component_object->screen_function )
        );
    }else{
        esc_html_e( 'This page does not exist.', 'streamtube-core' );
    }
    echo '</div>';
} 