<?php
/**
 *
 * Delete Users template file
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp;

$users = isset( $_REQUEST['users'] ) ? wp_unslash( $_REQUEST['users'] ) : array();

if ( ! $users ) {
	return streamtube_core_the_notice(
		esc_html__( 'Users were not found.', 'streamtube-core' ),
		'danger'
	);
}

// Always check capability
if ( ! current_user_can( 'delete_users' ) ) {
	return streamtube_core_the_notice(
		esc_html__( 'You do not have permission to delete users.', 'streamtube-core' ),
		'danger'
	);
}
?>

<form class="form-ajax">

	<div class="bg-white border p-4 mb-4">
		<ul class="list-group list-group-flush">

			<?php for ( $i = 0; $i < count( $users ); $i++ ) {

				if ( current_user_can( 'delete_user', $users[ $i ] ) ) {
					$user = get_userdata( $users[ $i ] );
					printf(
						'<li class="bg-white list-group-item border-bottom"><a class="text-decoration-none text-body" target="_blank" href="%s">#%s%s: %s %s</a></li>',
						esc_url( get_author_posts_url( $users[ $i ] ) ),
						esc_html__( 'ID', 'streamtube-core' ),
						$users[ $i ],
						$user->user_login,
						get_current_user_id() === (int) $users[ $i ] || user_can( $users[ $i ], 'administrator' ) ? '<span class="text-danger">' . esc_html__( 'This user will not be deleted.', 'streamtube-core' ) . '</span>' : ''
					);
				}
			} ?>

		</ul>
	</div>

	<?php load_template( untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/reassign-user.php' ); ?>

	<?php printf(
		'<input type="hidden" name="action" value="%s" />',
		'streamtube/delete_users'
	); ?>

	<?php printf(
		'<input type="hidden" name="users" value="%s" />',
		esc_attr( join( ',', $users ) )
	); ?>

	<?php printf(
		'<input type="hidden" name="_wpnonce" value="%s" />',
		esc_attr( wp_create_nonce( 'delete_users_' . join( ',', $users ) ) )
	); ?>

	<?php printf(
		'<input type="hidden" name="redirect_uri" value="%s" />',
		esc_url( home_url( $wp->request ) )
	); ?>

	<div class="d-flex gap-3">

		<button type="submit" class="btn btn-danger px-3">
			<span class="btn__icon icon-trash-empty me-2"></span>
			<?php esc_html_e( 'Confirm Deletion', 'streamtube-core' ); ?>
		</button>

		<?php printf(
			'<a class="text-body" href="%s">%s</a>',
			esc_url( home_url( $wp->request ) ),
			esc_html__( 'Back', 'streamtube-core' )
		) ?>

	</div>

</form>