<?php
/**
 *
 * Reset Users's storage template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $wp, $streamtube;

$users = isset( $_REQUEST['users'] ) ? wp_unslash( $_REQUEST['users'] ) : array();

if( ! $users ){
    return streamtube_core_the_notice(
        esc_html__( 'Users were not found.', 'streamtube-core' ),
        'danger'
    );    
}

// Always check capability
if ( ! current_user_can( 'edit_users' ) ) {
    return streamtube_core_the_notice(
        esc_html__( 'You do not have permission to edit users.', 'streamtube-core' ),
        'danger'
    );    
}
?>
<form class="form-ajax">
    <ul class="list-group list-group-flush mb-4">
        
        <?php for ( $i=0; $i < count( $users ); $i++) { 

            if( current_user_can( 'delete_user', $users[$i] ) ){
                $user = get_userdata( $users[$i] );
                printf(
                    '<li class="list-group-item bg-light border-bottom"><a class="text-decoration-none text-body" target="_blank" href="%s">#%s%s: %s</a></li>',
                    esc_url( get_author_posts_url( $users[$i] ) ),
                    esc_html__( 'ID', 'streamtube-core' ),
                    $users[$i],
                    $user->user_login
                );
            }
        }?>

    </ul>

    <?php printf(
        '<input type="hidden" name="action" value="%s" />',
        'streamtube/core/storage/reset_users_storage_quota'
    ); ?>

    <?php printf(
        '<input type="hidden" name="users" value="%s" />',
        esc_attr( join(',', $users ) )
    ); ?>    

    <?php printf(
        '<input type="hidden" name="_wpnonce" value="%s" />',
        esc_attr( wp_create_nonce( 'reset_users_storage_quota_' . join(',', $users ) ) )
    ); ?> 

    <?php printf(
        '<input type="hidden" name="redirect_uri" value="%s" />',
        esc_url( home_url( $wp->request ) )
    ); ?>       

    <div class="alert bg-warning">
        <p><?php esc_html_e( 'Caution: ', 'streamtube-core' );?></p>
        <ul class="m-0">
            <li>
                <?php printf(
                    esc_html__( 'Resetting the quota will remove all usage entries, including %s and %s types.', 'streamtube-core' ),
                    '<strong class="text-danger">'. implode(', ', array_values( $streamtube->get()->storage->get_custom_object_types() ) ) .'</strong>',
                    '<strong class="text-danger">'. esc_html__('Attachment' ) .'</strong>'
                );?>
            </li>
        </il>
    </div>

    <?php
        streamtube_core_the_field_control( array(
            'type'  =>  'text',
            'label' =>  esc_html__( 'Type RESET to confirm', 'streamtube-core' ),
            'name'  =>  'confirm'
        ) );    
    ?>    

    <div class="d-flex gap-3">
    
        <button type="submit" class="btn btn-danger px-3">
            <span class="btn__icon icon-trash-empty me-2"></span>
            <?php esc_html_e( 'Confirm Reset', 'streamtube-core' );?>
        </button>

        <?php printf(
            '<a class="text-body" href="%s">%s</a>',
            esc_url( home_url( $wp->request ) ),
            esc_html__( 'Back', 'streamtube-core' )
        )?>

    </div>
</form>    