<?php
/**
 *
 * User Storage Quota template file
 * 
 */
if( ! defined('ABSPATH' ) ){
    exit;
}

global $wp, $streamtube;

$user_id    = isset( $_REQUEST['user_id'] ) ? absint( $_REQUEST['user_id'] ) : 0;

$userdata   = get_userdata( $user_id );

// Always check capability
if ( ! current_user_can( 'edit_user', $user_id ) || ! $userdata ) {
    return streamtube_core_the_notice(
        esc_html__( 'You do not have permission to edit this user.', 'streamtube-core' ),
        'danger'
    );    
}

echo $streamtube->get()->storage->get_user_storage_progres( array_merge( compact( 'user_id' ), array(
    'hide_if_unlimited_or_not_allowed' =>  false,
    'wrap'                             =>  true
) ) );
?>

<form class="form-ajax mb-4 p-4 bg-white shadow-sm">

    <?php
        streamtube_core_the_field_control( array(
            'type'  =>  'text',
            'label' =>  esc_html__( 'Initial quota', 'streamtube-core' ),
            'name'  =>  'size',
            'value' =>  $streamtube->get()->storage->get_user_storage_initial_quota( $user_id ) / ( 1024*1024 ),
            'description'   =>  sprintf(
                esc_html__( 'Maximum initial storage capacity in %s for the %s user. Set to 0 for unlimited storage.', 'streamtube-core' ),
                '<strong class="text-info">'. esc_html__( 'MB', 'streamtube-core' ) .'</strong>',
                sprintf(
                    '(%s) %s',
                    $userdata->user_login,
                    $userdata->display_name
                )
            )
        ) );    
    ?>

    <?php printf(
        '<input type="hidden" name="action" value="%s" />',
        'streamtube/core/storage/update_user_quota'
    ); ?>

    <?php printf(
        '<input type="hidden" name="user_id" value="%s" />',
        esc_attr( $user_id )
    ); ?>    

    <?php printf(
        '<input type="hidden" name="_wpnonce" value="%s" />',
        esc_attr( wp_create_nonce( 'update_user_storage_quota_' . $user_id ) )
    ); ?> 

    <?php printf(
        '<input type="hidden" name="redirect_uri" value="%s" />',
        esc_url( home_url( $wp->request ) )
    ); ?>        

    <div class="d-flex gap-3 mt-4">
    
        <button type="submit" class="btn btn-danger btn-sm px-4">
            <span class="btn__icon icon-pencil"></span>
            <span class="btn__text"><?php esc_html_e( 'Update', 'streamtube-core' );?></span>
        </button>

        <?php printf(
            '<a class="text-body" href="%s">%s</a>',
            esc_url( home_url( $wp->request ) ),
            esc_html__( 'Back', 'streamtube-core' )
        )?>

    </div>
</form>

<hr/>

<form class="form-ajax mb-4 p-4 bg-white shadow-sm">
    <?php
        streamtube_core_the_field_control( array(
            'type'  =>  'text',
            'label' =>  esc_html__( 'Add manual quota', 'streamtube-core' ),
            'name'  =>  'size',
            'value' =>  '',
            'description'   =>  sprintf(
                esc_html__( 'Manually add storage capacity in %s for the %s user.', 'streamtube-core' ),
                '<strong class="text-info">'. esc_html__( 'MB', 'streamtube-core' ) .'</strong>',
                sprintf(
                    '(%s) %s',
                    $userdata->user_login,
                    $userdata->display_name
                )
            )
        ) );    
    ?>

    <?php
        streamtube_core_the_field_control( array(
            'type'          =>  'textarea',
            'label'         =>  esc_html__( 'Tell user more about this manual quota', 'streamtube-core' ),
            'name'          =>  'description',
            'value'         =>  ''
        ) );    
    ?>    

    <?php printf(
        '<input type="hidden" name="action" value="%s" />',
        'streamtube/core/storage/add_user_manual'
    ); ?>

    <?php printf(
        '<input type="hidden" name="user_id" value="%s" />',
        esc_attr( $user_id )
    ); ?>    

    <?php printf(
        '<input type="hidden" name="_wpnonce" value="%s" />',
        esc_attr( wp_create_nonce( 'add_user_manual_' . $user_id ) )
    ); ?> 

    <?php printf(
        '<input type="hidden" name="redirect_uri" value="%s" />',
        esc_url( home_url( $wp->request ) )
    ); ?>        

    <div class="d-flex gap-3 mt-4">
    
        <button type="submit" class="btn btn-primary btn-sm px-4">
            <span class="btn__icon icon-plus"></span>
            <span class="btn__text"><?php esc_html_e( 'Add', 'streamtube-core' );?></span>
        </button>

    </div>    
</form>

<?php

if( shortcode_exists( 'user_storage_table' ) ){
    echo do_shortcode( sprintf(
        '[user_storage_table user_id="%s"]',
        $user_id
    ) );
}