<?php
/**
 * Users List Table Template
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

$wp_list_table = new StreamTube_Core_Users_List_Table( array(
    'screen'    =>  'edit-users',
    'ajax'      =>  true
) );

streamtube_core_the_screen_options( $wp_list_table );

$action     = $wp_list_table->current_action();
$nonce      = isset( $_REQUEST['_wpnonce'] )    ? wp_unslash( $_REQUEST['_wpnonce'] )   : '';
$user_id    = isset( $_REQUEST['user_id'] )     ? absint( $_REQUEST['user_id'] )        : 0;
$users      = isset( $_REQUEST['users'] )       ? wp_unslash( $_REQUEST['users'] )      : array();

$_nonce     = $action . '-' . $user_id;

$actions = array();

if( $user_id && $action ){
    if( ! wp_verify_nonce( $nonce, $_nonce ) ){
        return streamtube_core_the_notice(
            esc_html__( 'The link you followed has expired.', 'streamtube-core' ),
            'danger'
        );
    }
}

if( $user_id && false === $userdata = get_userdata( $user_id ) ){
    return streamtube_core_the_notice(
        esc_html__( 'User does not exist.', 'streamtube-core' ),
        'danger'
    );    
}

if( $users && $action === 'delete' ){
    $action = 'delete_users';
}

$title = esc_html__( 'Users', 'streamtube-core' );

switch ( $action ) {
    case 'delete':
        $title = sprintf(
            esc_html__( 'Delete %s', 'streamtube-core' ),
            $userdata->user_login
        );
    break;

    case 'delete_users':
        $title = esc_html__( 'Delete users', 'streamtube-core' );
    break;    
    
    case 'change-password':
        $title = sprintf(
            esc_html__( 'Change %s\'s password', 'streamtube-core' ),
            $userdata->user_login
        );
    break;

    case 'roles':
        $title = sprintf(
            esc_html__( 'Change %s\'s roles', 'streamtube-core' ),
            $userdata->user_login
        );
    break;

    case 'capabilities':
        $title = sprintf(
            esc_html__( 'Change %s\'s capabilities', 'streamtube-core' ),
            $userdata->user_login
        );
    break;

    case 'storage-quota':
        $title = sprintf(
            esc_html__( 'Edit %s\'s storage quota', 'streamtube-core' ),
            $userdata->user_login
        );
    break;

    case 'reset_storage_quota':
        $title = esc_html__( 'Reset storage quota', 'streamtube-core' );
    break;                   
}

streamtube_core_the_dashboard_head( apply_filters( 'streamtube/core/users_list_table/title', $title, $action ) );

streamtube_core_the_dashboard_content_start();

?>
    <div class="wp-core-ui">
        <div id="wpbody-content">

            <?php 

            switch ( $action ) {
                case 'delete':
                case 'delete_users':
                case 'change-password':
                case 'capabilities':
                case 'roles':
                case 'storage-quota':
                case 'reset_storage_quota':
                    load_template( trailingslashit( plugin_dir_path( __FILE__ ) ) . $action . '.php' );
                break;

                default:

                $wp_list_table->prepare_items();

                $wp_list_table->views();

                ?>
                <form method="get">

                    <?php $wp_list_table->search_box( __( 'Search Users' ), 'user' ); ?>

                    <?php if ( ! empty( $_REQUEST['role'] ) ) { ?>
                        <input type="hidden" name="role" value="<?php echo esc_attr( $_REQUEST['role'] ); ?>" />
                    <?php } ?>

                    <?php $wp_list_table->display(); ?>

                </form>
                <?php

                break;
            }

            ?>
        </div>

    </div>
<?php

streamtube_core_the_dashboard_content_end();