<?php
/**
 * Define the Advanced Custom Fields functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.1
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class StreamTube_Core_ACF {

	public $Form_Post;

	public $Form_User;

	public function __construct() {

		$this->load_dependencies();

		$this->Form_Post = new StreamTube_Core_ACF_Form_Post();

		$this->Form_User = new StreamTube_Core_ACF_Form_User();

	}

	/**
	 *
	 * Include file
	 * 
	 * @param  string $file
	 *
	 * @since 2.0
	 * 
	 */
	private function include_file( $file ) {
		require_once untrailingslashit( plugin_dir_path( __FILE__ ) ) . $file;
	}

	/**
	 *
	 * Load dependencies
	 *
	 * @since 2.0
	 * 
	 */
	private function load_dependencies() {
		$this->include_file( '/class-streamtube-core-acf-form-post.php' );
		$this->include_file( '/class-streamtube-core-acf-form-user.php' );
	}
}