<?php
/**
 *
 * The Sync template file
 * 
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      2.1
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
    exit;
}

wp_enqueue_style( 'select2' );
wp_enqueue_script( 'select2' );

$taxonomies = get_object_taxonomies( 'video', 'object' );

?>
<table class="form-table">
        
    <tbody>

        <tr>
            <th scope="row"><label for="auto_import_uploads"><?php esc_html_e( 'Auto Import', 'streamtube-core' );?></label></th>
            <td>
                <label for="auto_import_uploads">
                    <?php printf(
                        '<input name="bunnycdn[auto_import_uploads]" type="checkbox" id="auto_import_uploads" %s>',
                        checked( 'on', $settings['auto_import_uploads'], false )
                    );?>
                    <?php esc_html_e( 'Auto-import newly videos from Bunny Stream.', 'streamtube-core' );?>
                </label>
            </td>
        </tr>

        <tr>
            <th scope="row"><label for="auto_import_author_id"><?php esc_html_e( 'Default Author ID', 'streamtube-core' );?></label></th>
            <td>
                <?php printf(
                    '<input name="bunnycdn[auto_import_author_id]" type="text" id="auto_import_author_id" value="%s" class="regular-text">',
                    esc_attr( $settings['auto_import_author_id'] )
                );?>
                <p class="description">
                    <?php esc_html_e( 'Default owner ID for imported posts', 'streamtube-core' );?>
                </p>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="auto_import_post_status">
                    <?php esc_html_e( 'Default Status', 'streamtube-core' );?>
                </label>
            </th>
            <td>
                <select name="bunnycdn[auto_import_post_status]" id="auto_import_post_status">
                    <?php foreach ( get_post_statuses() as $key => $value ): ?>
                        <?php printf(
                            '<option value="%s" %s>%s</option>',
                            esc_attr( $key ),
                            selected( $key, $settings['auto_import_post_status'], false ),
                            esc_html( $value )
                        ); ?>
                    <?php endforeach ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row"><label for="auto_import_auto_cat"><?php esc_html_e( 'Auto Categorization', 'streamtube-core' );?></label></th>
            <td>
                <label for="auto_import_auto_cat">
                    <?php printf(
                        '<input name="bunnycdn[auto_import_auto_cat]" type="checkbox" id="auto_import_auto_cat" %s>',
                        checked( 'on', $settings['auto_import_auto_cat'], false )
                    );?>
                </label>
            </td>
        </tr>        

        <?php if( $taxonomies ): ?>
            <?php foreach ( $taxonomies as $tax => $object ): ?>
                <?php if( ! in_array( $tax , array( 'report_category' ) ) ) :?>
                <tr>
                    <th scope="row">
                        <label for="syn_tax_<?php echo $tax; ?>">
                            <?php printf(
                                esc_html__( 'Default %s', 'streamtube-core' ),
                                $object->label
                            )?>
                        </label>
                    </th>
                    <td>
                        <?php 
                            
                            $terms = get_terms( array(
                                'taxonomy'  =>  $tax,
                            ) );

                            echo '<select class="regular-text select-select2" name="bunnycdn[auto_import_tax_' . $tax . '][]" multiple>';

                                foreach ( $terms as $term ) {

                                    $_term = $settings[ 'auto_import_tax_' . $tax ];
                                    $value = is_taxonomy_hierarchical( $tax ) ? $term->term_id : $term->slug;

                                    printf(
                                        '<option %s value="%s">%s</option>',
                                        ( is_array( $_term ) && in_array( $term->term_id, $_term )) ? 'selected' : '',
                                        esc_attr( $value ),
                                        esc_html( $term->name )
                                    );
                                }

                            echo '</select>';

                        ?>
                    </td>
                </tr>   
                <?php endif;?>               
            <?php endforeach;?>
        <?php endif;?>

    </tbody>

</table>

<script type="text/javascript">
    jQuery( document ).ready(function() {
        jQuery( '.select-select2' ).select2({
            placeholder: '<?php esc_html_e( 'Select', 'streamtube-core' );?>',
            scrollAfterSelect : true,
            allowClear : true
        });
    });
</script>