<?php
/**
 *
 * The Security template file
 * 
 *
 * @link       https://1.envato.market/mgXE4y
 * @since      2.1
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if( ! defined( 'ABSPATH' ) ){
    exit;
}

?>

<h3>
    <?php esc_html_e( 'Secure Videos with Token Authentication', 'streamtube-core' );?>
</h3>

<table class="form-table">
        
    <tbody>

        <tr>
            <th scope="row"><label for="token_auth_key"><?php esc_html_e( 'Token Authentication Key', 'streamtube-core' );?></label></th>
            <td>
                <?php printf(
                    '<input name="bunnycdn[token_auth_key]" type="text" id="token_auth_key" value="%s" class="regular-text">',
                    esc_attr( $settings['token_auth_key'] )
                );?>
                <p class="description">
                    <?php printf(
                        esc_html__( 'The %s used for generating the token hash', 'streamtube-core' ),
                        '<a target="_blank" href="https://dash.bunny.net/stream/'. $settings['libraryId'] .'/security/general">'. esc_html__( 'private key', 'streamtube-core' ) .'</a>'
                    );?>
                </p>
            </td>
        </tr>

        <tr>
            <th scope="row"><label for="token_expires"><?php esc_html_e( 'Token Expiration', 'streamtube-core' );?></label></th>
            <td>
                <?php printf(
                    '<input name="bunnycdn[token_expires]" type="text" id="token_expires" value="%s" class="regular-text">',
                    esc_attr( $settings['token_expires'] )
                );?>
                <p class="description">
                    <?php esc_html_e( 'The token expiration used for generating the token hash', 'streamtube-core' );?>
                </p>                
            </td>
        </tr>

    </tbody>

</table>