<?php
/**
 * Define the jwt-authentication functionality
 *
 * @link https://wordpress.org/plugins/jwt-authentication-for-wp-rest-api/
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.1
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

class StreamTube_Core_JWT_Auth{
    /**
     *
     * Add an `Access Token` menu item under the Account
     *
     */
    public static function register_dashboard_menu( $menu_items ){
        if( isset( $menu_items['account'] ) ){
            $menu_items['account']['submenu']['jwtauth'] = array(
                'title'     =>  esc_html__( 'Access Token', 'streamtube-core' ),
                'icon'      =>  'icon-lock',
                'callback'  =>  function(){
                    streamtube_core_load_template( 'user/dashboard/account/jwt-authenticate.php' );
                },
                'cap'       =>  'read',
                'priority'  =>  50                
            );
        }

        return $menu_items;
    }

}
