<?php
/**
 * Define the Patreon Metabox functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.1
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Patron_Metabox' ) ) {
	return;
}
/**
 * Class StreamTube_Core_Patreon_Metabox
 *
 * This class extends the Patron_Metabox class and is part of the StreamTube Core plugin.
 *
 * @package StreamTube_Core
 * @subpackage Patreon
 */
class StreamTube_Core_Patreon_Metabox extends Patron_Metabox {

	function __construct() {
	}

	/**
	 * Adds meta boxes for Patreon level to the specified post types.
	 *
	 * This function retrieves the public post types and adds a meta box for each
	 * post type to the dashboard. The meta box is used to display and manage the
	 * Patreon level for the post.
	 *
	 * @param string $post_type The post type. Default is an empty string.
	 * @param WP_Post|null $post The post object. Default is null.
	 */
	public function add_dashboard_meta_boxes( $post_type = '', $post = null ) {

		$screens = array();

		foreach ( streamtube_core_get_public_post_types() as $_post_type ) {
			if ( post_type_supports( $_post_type, 'patreon' ) ) {
				$screens[] = "dashboard_{$_post_type}";
			}
		}

		streamtube_add_meta_box(
			'patreon-level',      // Unique ID
			esc_html__( 'Patreon Level', 'streamtube-core' ),
			array( $this, 'patreon_plugin_meta_box' ),
			$screens,
			'side',
			'default'
		);
	}
}