<?php
if( ! defined('ABSPATH' ) ){
    exit;
}

$user_id = get_current_user_id();

//make sure they have codes
$codes = pmproio_getInviteCodes( $user_id );

streamtube_core_the_dashboard_content_start();
?>

<div id="pmproio_codes" class="pmpro_box clear">

	<?php if( $codes ): ?>

	<div class="mb-4">
		<?php if( count( $codes ) == 1 ) { ?>
			<p class="text-secondary"><?php esc_html_e('Give this code to your invited member to use at checkout', 'streamtube-core'); ?></p>
		<?php } else { ?>
			<p class="text-secondary"><?php esc_html_e('Give these codes to your invited members to use at checkout', 'streamtube-core'); ?></p>
		<?php } ?>

		<?php echo pmproio_displayInviteCodes(); ?>
	</div>

	<div class="mb-4">

		<h6 class="page-title h6"><?php esc_html_e('Used Invite Codes', 'streamtube-core' ); ?></h6>
		
		<p class="text-secondary"><?php echo pmproio_displayInviteCodes( $user_id, false, true); ?></p>

	</div>

	<?php else:?>

		<p class="text-secondary">
			<?php esc_html_e( 'No Invite Codes were found', 'streamtube-core' ); ?>
		</p>

	<?php endif;?>
</div>

<?php
streamtube_core_the_dashboard_content_end();