<?php
/**
 * 
 * The Subscriptions template file
 * 
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Renders the Profile Builder account shortcode within the StreamTube Core plugin.
 *
 * This function applies a filter to the default shortcode '[pms-account]' allowing
 * for customization before rendering it using the `do_shortcode` function.
 *
 * @return string The rendered HTML output of the Profile Builder account shortcode.
 */
$shortcode = do_shortcode(
	apply_filters( 'streamtube/core/pmsubscriptions/dashboard_shortcode', '[pms-account]' )
);

streamtube_core_the_dashboard_head( esc_html__( 'Subscriptions', 'streamtube-core' ) );

streamtube_core_the_dashboard_content_start();

/**
 * Outputs the subscription shortcode within a div.
 *
 * @param string $shortcode The subscription shortcode to be displayed.
 *
 * @return void
 */
printf(
	'<div class="pms-dashboard">%s</div>',
	$shortcode
);

streamtube_core_the_dashboard_content_end();