<?php
/**
 * The Storage Usage table template file
 * 
 * @link       https://1.envato.market/mgXE4y
 * @since      2.1
 *
 * @package    WordPress
 * @subpackage StreamTube
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$args = wp_parse_args( $args, 
    array( 
        'user_id'           =>  0,
        'heading'           =>  esc_html__( 'Storage Usage', 'streamtube-core' )
    ) 
);

extract( $args );

$wp_list_table = new StreamTube_Core_Storage_Usage_Table( compact( 'user_id' ) );

streamtube_core_the_screen_options( $wp_list_table );

$wp_list_table->prepare_items();

streamtube_core_the_dashboard_head( $args['heading'] );

streamtube_core_the_dashboard_content_start();    
?>
<div class="wp-core-ui">
    <div id="wpbody-content">

        <?php $wp_list_table->views(); ?>

        <form method="get">

            <?php $wp_list_table->search_box('Search', 'search'); ?>

            <?php $wp_list_table->display(); ?>

            <?php if( isset( $_REQUEST['user_id'] ) ){
                printf(
                    '<input type="hidden" name="user_id" value="%s">',
                    esc_attr( $_REQUEST['user_id'] )
                );

                if( isset( $_REQUEST['_wpnonce'] ) ){
                    printf(
                        '<input type="hidden" name="_wpnonce" value="%s">',
                        esc_attr( $_REQUEST['_wpnonce'] )
                    );
                }                

                if( isset( $_REQUEST['action'] ) ){
                    printf(
                        '<input type="hidden" name="action" value="%s">',
                        esc_attr( $_REQUEST['action'] )
                    );
                }
            }?>
        </form>

    </div>
</div>
<?php    
streamtube_core_the_dashboard_content_end();