<?php
/**
 * Define the Stripe functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      2.2
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      2.2
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Streamtube_Core_WooCommerce_Stripe {

	/**
	 * Filter the Stripe UPE parameters to customize the appearance.
	 *
	 * This function modifies the Stripe UPE parameters to set the appearance
	 * themes for the payment blocks and the overall appearance.
	 *
	 * @param array $stripe_params The original Stripe parameters.
	 * @return array The modified Stripe parameters with custom appearance settings.
	 */
	public function filter_stripe_upe_params( $stripe_params ) {

		$appearance = 'flat';

		if ( function_exists( 'streamtube_get_theme_mode' ) ) {
			$mode = streamtube_get_theme_mode();

			if ( $mode === 'dark' ) {
				$appearance = 'night';
			}
		}

		$stripe_params['appearance'] = (object) [ 'theme' => $appearance ];

		return $stripe_params;
	}
}