<?php
/**
 * Define the `FundEngine – Donation and Crowdfunding Platform` functionality
 *
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.3
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

/**
 *
 * @since      1.0.0
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 * @author     phpface <nttoanbrvt@gmail.com>
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

class StreamTube_Core_FundEngine{

	const SLUG = 'fundengine';

	/**
	 *
	 * Get menu slug
	 * 
	 * @return string
	 */
	public static function get_slug(){
		return apply_filters( 'streamtube/core/dashboard/fundengine_slug', self::SLUG );
	}

	/**
	 *
	 * Add `Funding` dashboard menu
	 * 
	 * @param array $menu_items
	 */
	public function add_dashboard_menu( $menu_items ){
	    $menu_items[ self::get_slug() ] = array(
	        'title'     =>  esc_html__( 'Funding', 'streamtube-child' ),
	        'icon'      =>  'icon-gittip',
	        'parent'    =>  'dashboard',
	        'cap'       =>  'read',
	        'callback'  =>  function(){
	        	load_template( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'fundengine.php' );
	        },
	        'priority'  =>  10
	    );    
	    return $menu_items;		
	}

	/**
	 *
	 * Flatpickr is conflicting with Dokan Pro on WC Checkout page
	 * 
	 * We dequeue Flatpickr css
	 */
	public function dequeue_flatpickr(){
		if( function_exists( 'WC' ) && function_exists( 'dokan_pro' ) ){
			if( function_exists( 'is_checkout' ) && is_checkout() ){
				wp_dequeue_style( 'flatpickr-wfp' );		
				wp_dequeue_script( 'flatpickr-wfp' );
			}
		}
	}

	/**
	 *
	 * Enqueue scripts
	 * 
	 */
	public function enqueue_scripts(){
	
		if( get_query_var( 'dashboard' ) === self::get_slug() ){
			/**
			 * css loading
			 */
			wp_enqueue_style( 'wfp_dashboard_css' );
			wp_enqueue_style( 'wfp_single_campaign_css' );
			/**
			 * js loading
			 */
			// chart js
			wp_enqueue_script( 'chartjs' );

			// dashboard
			wp_enqueue_script( 'wfp_dashboard_script' );				
			// form js laibray
			wp_enqueue_script( 'wfp_campaign_form_step' );
		}		

		wp_enqueue_style( 
			'streamtube-core-funding',
            plugin_dir_url( __FILE__ ) . 'assets/style.css', 
            array( 'streamtube-style', 'wfp_single_campaign_css', 'wfp_single_css', 'wfp_dashboard_css' ), 
            filemtime( plugin_dir_path( __FILE__ ) . 'assets/style.css' )
		);

	}

}