<?php
/**
 * Define the WP Statistics functionality
 *
 * https://wordpress.org/plugins/wp-statistics/
 *
 * @link       https://themeforest.net/user/phpface
 * @since      1.0.0
 *
 * @package    Streamtube_Core
 * @subpackage Streamtube_Core/includes
 */

if( ! defined('ABSPATH' ) ){
    exit;
}

class StreamTube_Core_WP_Statistics_Permission{

    /**
     * Get BunnyCDN capabilities
     *
     * Returns an object with capabilities mapped to specific permission keys.
     *
     * @return object
     */
    public static function get_capabilities() {
        return (object) array(
            'view_statistics'           => 'view_statistics',
            'view_all_statistics'       => 'view_all_statistics',
        );
    }   

    /**
     * Check permission to view statistics
     *
     * @return bool
     */
    public static function view_statistics() {
        return  current_user_can( self::get_capabilities()->view_statistics ) || 
                ( 
                    class_exists( 'WP_STATISTICS\Option' ) && 
                    current_user_can( WP_STATISTICS\Option::get('read_capability', 'manage_options') )
                );
    }

    /**
     * Check permission to view all statistics
     *
     * @return bool
     */
    public static function view_all_statistics() {
        return  current_user_can( self::get_capabilities()->view_all_statistics ) || 
                current_user_can( 'administrator' ) ||
                (
                    class_exists( 'WP_STATISTICS\Option' ) && 
                    current_user_can( WP_STATISTICS\Option::get( 'manage_capability', 'manage_options') )
                );
    }
}